% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_brackets.R
\name{add_brackets}
\alias{add_brackets}
\title{Add Labelled Brackets to Group Predictors in a Dot-and-Whisker Plot}
\usage{
add_brackets(p, brackets, face = "italic")
}
\arguments{
\item{p}{A dot-and-whisker plot generated by \code{dwplot}.}

\item{brackets}{A list of brackets; each element of the list should be a character vector consisting of (1) a label for the bracket, (2) the name of the topmost variable to be enclosed by the bracket, and (3) the name of the bottommost variable to be enclosed by the bracket.}

\item{face}{A typeface for the bracket labels; options are "plain", "bold", "italic", "oblique", and "bold.italic".}
}
\value{
The function returns a \code{gtable} object, which are viewed with \code{\link[gridExtra]{grid.arrange}}.

To save, wrap the \code{grid.arrange} command with \code{\link[ggplot2]{ggsave}}.
}
\description{
\code{add_brackets} draws brackets along the y-axis beyond the plotting area of a dot-and-whisker plot generated by \code{dwplot}, useful for labelling groups of predictors
}
\examples{
library(broom)
library(dplyr)

data(mtcars)
m1 <- lm(mpg ~ wt + cyl + disp, data = mtcars)
m1_df <- broom::tidy(m1) # create data.frame of regression results

p <- dwplot(m1_df) +
    scale_y_discrete(breaks = 4:1, labels=c("Intercept", "Weight", "Cylinders", "Displacement")) +
    theme_bw() + xlab("Coefficient") + ylab("") +
    geom_vline(xintercept = 0, colour = "grey50", linetype = 2) +
    theme(legend.position="none")

two_brackets <- list(c("Engine", "cyl", "disp"), c("Not Engine", "(Intercept)", "wt"))

g <- p \%>\% add_brackets(two_brackets)

gridExtra::grid.arrange(g)  # to display

# to save (not run)
#ggsave(file = "gridplot.pdf", g)

}

