% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{shape.index}
\alias{shape.index}
\title{shape.index}
\usage{
shape.index(mesh, origin = TRUE)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{origin}{logical, if TRUE the z of the mesh is adjusted so that the lowest z = 0;
see \code{\link{dkorigin}}}
}
\value{
A list of indices:
\itemize{
  \item Form factor (Horton, 1932)
  \item Basin elongation (Schum, 1956)
  \item Lemniscate ratio 'K' (Chorley et al., 1957)
}
}
\description{
Compute various shape indices.
}
\details{
A handful of indices have been developed to characterize the shape of natural
landscapes, including drainage basins. While some indices are very scale-sensitive (e.g.,
Gravelius' compactness coefficient), others are dimensionless.
Horton (1932) introduced a form factor computed as the quotient of the basin's surface area
over the square of the maximum basin length. Schumm (1956) developed a basin elongation index
computed as the quotient of twice the square root of surface area over the product of basin
length and the squareroot of pi. Lastly, Chorley et al. (1957) developed a lemniscate ratio
which corresponds to the ratio between the surface of a lemniscate of same length over the
basin area,and computed as (pi*(Length^2))/(4*Area).
}
\examples{
ShapInd <- shape.index(dkmodel$basin)
ShapInd$FormFactor
ShapInd$Elongation
ShapInd$K
}
\references{
\doi{10.1029/TR013i001p00350}{Horton (1932)}

\doi{10.1130/0016-7606(1956)67[597:EODSAS]2.0.CO;2}{Schumm (1956)}

\doi{10.2475/ajs.255.2.138}{Chorley et al. (1957)}
}
