% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{opc}
\alias{opc}
\title{orientation patch count}
\usage{
opc(mesh, bins = 8, min.size = 3, rotation = 0)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{bins}{the number of orientation bins to be defined (default set to 8)}

\item{min.size}{the minimal amount of polygons defining a "patch" (default set to 3)}

\item{rotation}{if applicable, the number of degrees to which bins are to be rotated.
By default the bins start from an angle of pi/2 and rotates clockwise.}
}
\value{
A data.frame displaying the number of patches and their size (number of triangles)
for each orientation bin. Note: if you want the surface area of each patch, see\code{\link{poly.network}}
}
\description{
Count the number of orientation patches using \code{\link{poly.network}}.
}
\examples{
#8 bins (default):
opc <- opc(dkmodel$complex)
#8 bins starting from mesial, as in Evans et al. 2007:
opc <- opc(dkmodel$complex, rotation = -(360/16))
#4 bins (mesial, buccal, distal and lingual):
opc <- opc(dkmodel$complex, bins = 4, rotation = -(360/8))

}
\references{
\doi{10.1038/nature05433}{Evans et al. (2007)}
}
\seealso{
\code{\link{orient}}

\code{\link{opcr}}
}
