% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributionByLevel.r
\name{contributionByLevel}
\alias{contributionByLevel}
\title{Retrieve average contribution by level for each predictor}
\usage{
contributionByLevel(da.object, fit.functions = NULL)
}
\arguments{
\item{da.object}{dominanceAnalysis object}

\item{fit.functions}{name of the fit indices to retrieve. If NULL, all fit indices will be retrieved}
}
\value{
a list. Key corresponds to fit-index and the value is a matrix, with contribution of each variable
                by level
}
\description{
Retrieve the average contribution by level for each predictor in a dominance analysis.
The average contribution defines conditional dominance.
}
\examples{
data(longley)
da.longley<-dominanceAnalysis(lm(Employed~.,longley))
contributionByLevel(da.longley)
}
\seealso{
Other retrieval methods: \code{\link{averageContribution}},
  \code{\link{dominanceMatrix}}, \code{\link{getFits}}
}
\concept{retrieval methods}
