% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{dodgr_flows_aggregate}
\alias{dodgr_flows_aggregate}
\title{dodgr_flows_aggregate}
\usage{
dodgr_flows_aggregate(graph, from, to, flows, wt_profile = "bicycle",
  contract = FALSE, heap = "BHeap", quiet = TRUE)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points **from** which aggregate flows are to
be calculated (see Details)}

\item{to}{Vector or matrix of points **to** which aggregate flows are to be
calculated (see Details)}

\item{flows}{Matrix of flows with \code{nrow(flows)==length(from)} and
\code{ncol(flows)==length(to)}.}

\item{wt_profile}{Name of weighting profile for street networks (one of foot,
horse, wheelchair, bicycle, moped, motorcycle, motorcar, goods, hgv, psv;
only used if \code{graph} is not provided, in which case a street network is
downloaded and correspondingly weighted).}

\item{contract}{If \code{TRUE}, calculate flows on contracted graph before
mapping them back on to the original full graph (recommended as this will
generally be much faster).}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
Modified version of graph with additonal \code{flow} column added.
}
\description{
Aggregate flows throughout a network based on an input matrix of flows
between all pairs of \code{from} and \code{to} points.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
to <- sample (graph$to_id, size = 5)
to <- to [!to \%in\% from]
flows <- matrix (10 * runif (length (from) * length (to)),
                 nrow = length (from))
graph <- dodgr_flows_aggregate (graph, from = from, to = to, flows = flows)
# graph then has an additonal 'flows` column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_flows (graph)
# This graph will only include those edges having non-zero flows, and so:
nrow (graph); nrow (graph_undir) # the latter is much smaller
}
