% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{rev.dnapath_list}
\alias{rev.dnapath_list}
\title{Reverse the order of pathways in a 'dnapath_list' object.}
\usage{
\method{rev}{dnapath_list}(x, ...)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{...}{Additional arguments are ignored.}
}
\value{
A 'dnapath_list' object containing the pathways in 'x' in reverse order.
}
\description{
Reverse the order of pathways in a 'dnapath_list' object.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
# Filter out pathways that have p-values above 0.2.
results <- filter_pathways(results, 0.2) 
results <- sort(results, by = "dc_score") # Sort by the pathway DC score.
results <- rev(results) # Reverse the ordering.
}
