% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{get_genes}
\alias{get_genes}
\title{Get the gene names from a differential network analysis}
\usage{
get_genes(x)
}
\arguments{
\item{x}{A 'dnapath_list' or 'dnapath' object from \code{\link{dnapath}},
or a pathway list.}
}
\value{
Returns a vector containing all the genes in \code{x}.
}
\description{
Get the gene names from a differential network analysis
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
genes <- get_genes(results)
}
\seealso{
\code{\link{rename_genes}}, \code{\link{entrez_to_symbol}},
\code{\link{symbol_to_entrez}}
}
