% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_list_na}
\alias{check_list_na}
\title{Auxiliary function to recursively check NAs in a list.}
\usage{
check_list_na(orig, des)
}
\arguments{
\item{orig}{A list whose content must be checked.}

\item{des}{A list to use as a reference with which compare the first one.}
}
\value{
A list with all elements added.
}
\description{
\code{check_list_na()} compares two lists and fills in the missing
  elements in the first with those included in the second. The
  comparison is recursive in the sense that the process is repeated for
  all lists included in those given.
}
\examples{
G <- 5
prior <- list(eta = list(a = rep(1, G), b = rep(2, G)))
check_list_na(prior, dmbc_prior())

}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
