% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\name{plot,dmbc_fit,ANY-method}
\alias{plot,dmbc_fit,ANY-method}
\alias{plot,dmbc_fit-method}
\alias{dmbc_fit-plot}
\title{Provide a graphical summary of a \code{dmbc_fit} class instance.}
\usage{
\S4method{plot}{dmbc_fit,ANY}(
  x,
  what = "trace",
  pars = character(),
  regex_pars = "lambda",
  include.burnin = FALSE,
  combo = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{dmbc_fit}}.}

\item{what}{A length-one character vector providing the plot type to produce.
Admissible values are those provided by the \pkg{\link{bayesplot}} package,
that is: \code{acf}, \code{areas}, \code{dens}, \code{hex}, \code{hist},
\code{intervals}, \code{neff}, \code{pairs}, \code{parcoord}, \code{recover},
\code{rhat}, \code{scatter}, \code{trace}, \code{violin} or \code{combo}.
In particular, \code{combo} allows to mix different plot types. For more
details see the documentation of the \pkg{\link{bayesplot}} package,
starting from \code{\link[=MCMC-overview]{this overview page}}.}

\item{pars}{An optional character vector of parameter names. If neither 
\code{pars} nor \code{regex_pars} is specified, the default is to use all parameters.}

\item{regex_pars}{An optional \code{\link[=grep]{regular expression}} to use for
parameter selection. Can be specified instead of \code{pars} or in addition to
\code{pars}.}

\item{include.burnin}{A length-one logical vector. If \code{TRUE} the
burnin iterations (if available) are included in the summary.}

\item{combo}{A character vector providing the plot types to combine (see
\code{\link[bayesplot]{mcmc_combo}}).}

\item{...}{Further arguments to pass on.}
}
\description{
Provide a graphical summary of a \code{dmbc_fit} class instance.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
