#' dmacs: A package for computing measurement nonequivalence effects.
#'
#' The dmacs package provides functions used to compute indices related to
#' the effects of measurement nonequivalence on observed scores, as
#' described in Nye and Drasgow (2011).
#'
#' @section dmacs functions:
#' The dmacs package includes helper functions that can compute the various
#' indices from Nye and Drasgow (2011) for fitted lavaan objects
#' (\code{\link{lavaan_dmacs}}) and Mplus output files
#' (\code{\link{mplus_dmacs}}). For users of other software and those
#' interested, specific functions for computing these indices for individual
#' items in individual focal groups are also available.
#'
#' @section References:
#' Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
#' measurement equivalence: Understanding the practical importance of
#' differences between groups. \emph{Journal of Applied Psychology, 96}(5),
#' 966-980.
#'
#' @docType package
#' @name dmacs

NULL
