% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-surgery.R
\name{decompose_table}
\alias{decompose_table}
\title{Decompose a table into two linked tables}
\usage{
decompose_table(.data, new_id_column, ...)
}
\arguments{
\item{.data}{Data frame from which columns \code{...} are to be extracted.}

\item{new_id_column}{Name of the identifier column (primary key column) for the parent table.
A column of this name is also added in 'child table'.}

\item{...}{The columns to be extracted from the \code{.data}.

One or more unquoted expressions separated by commas.
You can treat variable names as if they were positions, so you
can use expressions like x:y to select ranges of variables.

The arguments in ... are automatically quoted and evaluated in a context where column names represent column positions.
They also support
unquoting and splicing.
See vignette("programming") for an introduction to those concepts.

See select helpers for more details, and the examples about tidyselect helpers, such as starts_with(), everything(), ...}
}
\value{
A named list of length two:
\itemize{
\item entry "child_table": the child table with column \code{new_id_column} referring to the same column in \code{parent_table},
\item entry "parent_table": the "lookup table" for \code{child_table}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Perform table surgery by extracting a 'parent table' from a table, linking the original table and the new table by a key, and returning both tables.

\code{decompose_table()} accepts a data frame, a name for the 'ID column' that will be newly created, and the names
of the columns that will be extracted into the new data frame.

It creates a 'parent table', which consists of the columns specified in the ellipsis, and a new 'ID column'.
Then it removes those
columns from the original table, which is now called the 'child table, and adds the 'ID column'.
}
\section{Life cycle}{

This function is marked "experimental" because it seems more useful
when applied to a table in a dm object.
Changing the interface later seems harmless because these functions are
most likely used interactively.
}

\examples{
decomposed_table <- decompose_table(mtcars, new_id, am, gear, carb)
decomposed_table$child_table
decomposed_table$parent_table
}
\seealso{
Other table surgery functions: 
\code{\link{reunite_parent_child}()}
}
\concept{table surgery functions}
