% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pps.R
\name{pps}
\alias{pps}
\alias{pps.data.frame}
\alias{pps.target_df}
\title{Compute Predictive Power Score}
\usage{
pps(.data, ...)

\method{pps}{data.frame}(.data, ..., cv_folds = 5, do_parallel = FALSE, n_cores = -1)

\method{pps}{target_df}(.data, ..., cv_folds = 5, do_parallel = FALSE, n_cores = -1)
}
\arguments{
\item{.data}{a target_df or data.frame.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, describe() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{cv_folds}{integer. number of cross-validation folds.}

\item{do_parallel}{logical. whether to perform score calls in parallel.}

\item{n_cores}{integer. number of cores to use, defaults to maximum cores - 1.}
}
\value{
An object of the class as pps.
Attributes of pps class is as follows.
\itemize{
\item type : type of pps
\item target : name of target variable
\item predictor : name of predictor
}
}
\description{
The pps() compute PPS(Predictive Power Score) 
for exploratory data analysis.
}
\details{
The PPS is an asymmetric, data-type-agnostic score that can detect 
linear or non-linear relationships between two variables. 
The score ranges from 0 (no predictive power) to 1 (perfect predictive power).
}
\section{Information of Predictive Power Score}{

The information of PPS is as follows.

\itemize{
\item x : the name of the predictor variable
\item y : the name of the target variable
\item result_type : text showing how to interpret the resulting score
\item pps : the predictive power score
\item metric : the evaluation metric used to compute the PPS
\item baseline_score : the score of a naive model on the evaluation metric
\item model_score : the score of the predictive model on the evaluation metric
\item cv_folds : how many cross-validation folds were used
\item seed : the seed that was set
\item algorithm : text shwoing what algorithm was used
\item model_type : text showing whether classification or regression was used
}
}

\examples{
\donttest{
library(dplyr)

# pps type is generic =======================================
pps_generic <- pps(iris)
pps_generic

# summary pps class 
mat <- summary(pps_generic)
mat

# visualize pps class 
plot(pps_generic)


# pps type is target_by =====================================
##-----------------------------------------------------------
# If the target variable is a categorical variable
categ <- target_by(iris, Species)

# compute all variables
pps_cat <- pps(categ)
pps_cat

# compute Petal.Length and Petal.Width variable
pps_cat <- pps(categ, Petal.Length, Petal.Width)
pps_cat

# Using dplyr
pps_cat <- iris \%>\% 
  target_by(Species) \%>\% 
  pps()

pps_cat

# Using parallel process
# pps_cat <- iris \%>\% 
#   target_by(Species) \%>\% 
#   pps(do_parallel = TRUE)
# 
# pps_cat

# summary pps class 
tab <- summary(pps_cat)
tab

# visualize pps class
plot(pps_cat)

##-----------------------------------------------------------
# If the target variable is a numerical variable
num <- target_by(iris, Petal.Length)

pps_num <- pps(num)
pps_num

# summary pps class 
tab <- summary(pps_num)
tab

# plot pps class
plot(pps_num)
}

}
\references{
\itemize{
  \item RIP correlation. Introducing the Predictive Power Score - by Florian Wetschoreck
    \itemize{
      \item https://towardsdatascience.com/rip-correlation-introducing-the-predictive-power-score-3d90808b9598
    }
}
}
\seealso{
\code{\link{print.relate}}, \code{\link{plot.relate}}.
}
