% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{summary.imputation}
\alias{summary.imputation}
\title{Summarizing imputation information}
\usage{
\method{summary}{imputation}(object, ...)
}
\arguments{
\item{object}{an object of class "imputation", usually, a result of a call to imputate_na() or
imputate_outlier().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
print and summary method for "imputation" class.
}
\details{
summary.imputation() tries to be smart about formatting two kinds of imputation.
}
\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "platelets"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# Impute missing values -----------------------------
# If the variable of interest is a numerical variables
platelets <- imputate_na(heartfailure2, platelets, death_event, method = "rpart")
platelets
summary(platelets)
plot(platelets)

# If the variable of interest is a categorical variables
smoking <- imputate_na(heartfailure2, smoking, death_event, method = "mice")
smoking
summary(smoking)

# plot(smoking)

# Impute outliers ----------------------------------
# If the variable of interest is a numerical variable
platelets <- imputate_outlier(heartfailure2, platelets, method = "capping")
platelets
summary(platelets)

# plot(platelets)
}
}
\seealso{
\code{\link{imputate_na}}, \code{\link{imputate_outlier}}, \code{\link{summary.imputation}}.
}
