% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.bins}
\alias{plot.bins}
\title{Visualize Distribution for a "bins" object}
\usage{
\method{plot}{bins}(x, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "bins", usually, a result of a call to binning().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).}
}
\description{
Visualize two plots on a single screen.
The plot at the top is a histogram representing the frequency of the level.
The plot at the bottom is a bar chart representing the frequency of the level.
}
\examples{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "platelets"] <- NA

# Binning the carat variable. default type argument is "quantile"
bin <- binning(heartfailure2$platelets, nbins = 5)
plot(bin)

# Using another type arguments
bin <- binning(heartfailure2$platelets, nbins = 5, type = "equal")
plot(bin)

#bin <- binning(heartfailure2$platelets, nbins = 5, type = "pretty")
#plot(bin)

#bin <- binning(heartfailure2$platelets, nbins = 5, type = "kmeans")
#plot(bin)

bin <- binning(heartfailure2$platelets, nbins = 5, type = "bclust")
plot(bin)

}
\seealso{
\code{\link{binning}}, \code{\link{print.bins}}, \code{\link{summary.bins}}.
}
