% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\name{overview}
\alias{overview}
\title{Describe overview of data}
\usage{
overview(.data)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}
}
\value{
An object of overview class. 
The overview class contains data.frame and two attributes. data.frame has the following 3 variables.:
data.frame is as follow.:
\itemize{
  \item division : division of information.
  \itemize{
    \item size : indicators of related to data capacity 
    \item missing : indicators of related to missing value 
    \item data_type : indicators of related to data type 
  }
  \item metrics : name of metrics.
  \itemize{
    \item observations : number of observations (number of rows)
    \item variables : number of variables (number of columns)
    \item values : number of values (number of cells. rows * columns)
    \item memory_size : an estimate of the memory that is being used to store an R object.
    \item complete_obs : number of complete cases(observations). i.e., have no missing values.
    \item missing_obs : number of observations that has missing values.
    \item missing_vars : number of variables that has missing values.
    \item missing_values : number of values(cells) that has missing values.
    \item numerics : number of variables that is data type is numeric.
    \item integers : number of variables that is data type is integer.
    \item factors : number of variables that is data type is factor.
    \item characters : number of variables that is data type is character.
    \item others : number of variables that is not above.
  }
  \item value : value of metrics.
}

Attributes of overview class is as follows.:
\itemize{
  \item na_col : the data type of predictor to replace missing value.
  \item info_class : data.frame. variable name and class name that describe the data type of variables.
  \itemize{
    \item data.frame has a two variables.
    \itemize{
      \item variable : variable names
      \item class : data type
    }
  }
}
}
\description{
Inquire basic information to understand the data in general.
}
\details{
overview() creates an overview class.
The `overview` class includes general information such as the size of the data, the degree of missing values, 
and the data types of variables.
}
\examples{
\donttest{
ov <- overview(jobchange)
ov

summary(ov)

# plot(ov)
}

}
\seealso{
\code{\link{summary.overview}}, \code{\link{plot.overview}}.
}
