% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{plot.compare_numeric}
\alias{plot.compare_numeric}
\title{Visualize Information for an "compare_numeric" Object}
\usage{
\method{plot}{compare_numeric}(x, prompt = FALSE, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "compare_numeric", usually, a result of a call to compare_numeric().}

\item{prompt}{logical. The default value is FALSE. If there are multiple visualizations to be output, 
if this argument value is TRUE, a prompt is output each time.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
However, it does not support.}
}
\description{
Visualize scatter plot included box plots by attribute of compare_numeric class.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Reduced variables
library(dplyr)
carseats <- carseats \%>\% 
  select(CompPrice, Sales, Price)
  
# Compare the all numerical variables
all_var <- compare_numeric(carseats)

# Print compare compare_numeric object
all_var
  
# Compare the two numerical variables
two_var <- compare_numeric(carseats, CompPrice, Price)

# Print compare_numeric class object
two_var

# plot all pair of variables
plot(all_var)

# plot a pair of variables
plot(two_var)

# plot all pair of variables by prompt
# plot(all_var, prompt = TRUE)

# plot a pair of variables not focuses on typographic elements
plot(two_var, typographic = FALSE)

}
\seealso{
\code{\link{compare_numeric}}, \code{\link{print.compare_numeric}}, \code{\link{summary.compare_numeric}}.
}
