% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{uniqify}
\alias{uniqify}
\title{Find unique (taxon) occurrence records}
\usage{
uniqify(dat, xy, taxVar = NULL, na.rm = TRUE)
}
\arguments{
\item{dat}{A \code{data.frame} or \code{matrix} containing taxon names,
coordinates, and any associated variables; or a list of such structures.}

\item{xy}{A vector of two elements, specifying the name or numeric position
of columns in \code{dat} containing coordinates, e.g. longitude and latitude.
Coordinates for any shared sampling sites should be identical, and where sites
are raster cells, coordinates are usually expected to be cell centroids.}

\item{taxVar}{The name or numeric position of the column containing
taxonomic identifications. \code{taxVar} must be of same class as \code{xy}, e.g. a
numeric column position if \code{xy} is given as a vector of numeric positions.}

\item{na.rm}{Should records missing information be removed?
Default is yes.}
}
\value{
An object with the same class and columns as \code{dat}, containing the
subset of rows representing unique coordinates (if only \code{xy} supplied)
or unique taxon-site combinations (if \code{taxVar} is also supplied).
The first record at each spatial locality is retained,
or if \code{taxVar} is specified, the first record of each taxon at a locality.
}
\description{
Subset a dataset to unique spatial localities or locality-taxon combinations.
}
\details{
The \code{na.rm} argument applies to coordinate values and, if \code{taxVar}
is supplied, to taxon values. If \code{na.rm = FALSE}, any \code{NA} values will be
retained and treated as their own value. Note that \code{divvy} ignores any rows
with missing coordinates for the subsampling functions \code{\link[=cookies]{cookies()}},
\code{\link[=clustr]{clustr()}}, and \code{\link[=bandit]{bandit()}}.
}
\examples{
# generate occurrence data
x  <- rep(1, 10)
y  <- c(rep(1, 5), 2:6)
sp <- c(rep(letters[1:3], 2),
        rep(letters[4:5], 2))
obs <- data.frame(x, y, sp)

# compare original and unique datasets:
# rows 4 and 5 removed as duplicates of rows 1 and 2, respectively
obs
uniqify(obs, taxVar = 3, xy = 1:2)

# using taxon identifications or other third variable is optional
uniqify(obs, xy = c('x', 'y'))

# caution - data outside the taxon and occurrence variables
# will be lost where associated with duplicate occurrences
obs$notes <- letters[11:20]
uniqify(obs, 1:2, 3)
# the notes 'n' and 'o' are absent in the output data

}
