% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_ordinariness.R
\name{fun_ordinariness}
\alias{fun_ordinariness}
\title{Functional ordinariness of a community}
\usage{
fun_ordinariness(
  species_distribution,
  similarities = diag(sum(!colnames(species_distribution) \%in\% non_species_columns)),
  as_numeric = FALSE,
  check_arguments = TRUE
)
}
\arguments{
\item{species_distribution}{An object of class \link{species_distribution}.}

\item{similarities}{A similarity matrix, that can be obtained by \link{fun_similarity}.
Its default value is the identity matrix.}

\item{as_numeric}{If \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the ordinariness of each species, or a matrix if
argument \code{as_numeric} is \code{TRUE}.
}
\description{
The ordinariness of a species is the average similarity of its individuals
with others \insertCite{Leinster2012}{divent}.
}
\details{
All species of the \code{species_distribution} must be found in the matrix of
\code{similarities} if it is named.
If it is not, its size must equal the number of species.
Then, the order of species is assumed to be the same as that of the
\code{species_distribution}.
}
\examples{
fun_ordinariness(paracou_6_abd, fun_similarity(paracou_6_fundist))

# Compare with probabilities
probabilities(paracou_6_abd)
# Decrease similarities so that ordinariness is close to probability
fun_ordinariness(paracou_6_abd, fun_similarity(paracou_6_fundist, rate = 100))

}
\references{
\insertAllCited{}
}
