% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{fitNLSbouts,data.frame-method}
\alias{fitNLSbouts,data.frame-method}
\alias{fitNLSbouts}
\alias{fitNLSbouts,Bouts-method}
\title{Fit mixture of Poisson Processes to Log Frequency data via Non-linear
Least Squares regression}
\usage{
\S4method{fitNLSbouts}{data.frame}(obj, start, maxiter, ...)

\S4method{fitNLSbouts}{Bouts}(obj, start, maxiter, ...)
}
\arguments{
\item{obj}{Object of class \code{\link{Bouts}}, or
\code{\link{data.frame}} with named components \var{lnfreq} (log
frequencies) and corresponding \var{x} (mid points of histogram
bins).}

\item{start, maxiter}{Arguments passed to \code{\link{nls}}.}

\item{...}{Optional arguments passed to \code{\link{nls}}.}
}
\value{
\code{nls} object resulting from fitting this model to data.
}
\description{
Methods for modelling a mixture of 2 or 3 random Poisson processes to
histogram-like data of log frequency vs interval mid points.  This
follows Sibly et al. (1990) method.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Fit NLS model on \code{data.frame}

\item \code{Bouts}: Fit NLS model on \code{Bouts} object
}}

\examples{
## Run example to retrieve random samples for two- and three-process
## Poisson mixtures with known parameters as 'Bouts' objects
## ('xbouts2', and 'xbouts3'), as well as starting values from
## broken-stick model ('startval2' and 'startval3')
utils::example("boutinit", package="diveMove", ask=FALSE)

## 2-process
bout2.fit <- fitNLSbouts(xbouts2, start=startval2, maxiter=500)
summary(bout2.fit)
bec(bout2.fit)

## 3-process
## The problem requires using bound constraints, which is available
## via the 'port' algorithm
l_bnds <- c(100, 1e-3, 100, 1e-3, 100, 1e-6)
u_bnds <- c(5e4, 1, 5e4, 1, 5e4, 1)
bout3.fit <- fitNLSbouts(xbouts3, start=startval3, maxiter=500,
                         lower=l_bnds, upper=u_bnds, algorithm="port")
plotBouts(bout3.fit, xbouts3)
}
\references{
Sibly, R.; Nott, H. and Fletcher, D. (1990) Splitting behaviour into
bouts Animal Behaviour \bold{39}, 63-69.
}
\seealso{
\code{fitMLEbouts} for a better approach;
    \code{\link{boutfreqs}}; \code{\link{boutinit}}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{manip}
\keyword{models}
