% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repmatch.R
\name{repmatch}
\alias{repmatch}
\title{Replicate matching and merging}
\usage{
repmatch(x, FUN = NULL, proto = NULL, direct = c("dim", "name"), ...)
}
\arguments{
\item{x}{(\code{list}): A \code{list} of replicates.}

\item{FUN}{(\code{function}): A function to merge with and to be applied to the values of identical positions in different replicates. This function must have a single output value, \code{vectors} are not allowed. The default \code{NULL} option returns an element-wise reorganization of the data.}

\item{proto}{(\code{same as x[[1]]}): The prototype for matching/merging. The prototype is used as a check (\code{"dim"}) or a template (\code{"name"}) during the matching process, depending on the used directive (\code{direct} argument).  It is an object with the same class as the replicates, and have the same dimensions and/or overlapping names. If the \code{"name"} directive is used and a \code{prototype} is provided, the funtion will force the output to have the same structure as the prototype, by omitting unnecessary information and inserting missing values (\code{NAs}). The prototype is expected to be an object that has more or equal elements than the replicates, otherwise the call will result in a warning.}

\item{direct}{(\code{character}): Matching directive(s). Can either be dimension-based (\code{"dim"}) and/or name-based (\code{name}). Dimension-based directive matches the replicates if they have the same dimesions. The \code{"name"} directive requires named input (for \code{matrices} and \code{data.frames} \code{colnames} and \code{rownames} attributes). Replicates will be matched if the values have the same names. In case both directives are specified (default), dimension-based directive takes higher priority, if matching is unsuccessful with dimensions, names will be tried after.}

\item{...}{arguments passed to \code{FUN}.}
}
\value{
If \code{FUN} is a \code{function}, the output is \code{vector} for \code{vector}-like replicates, \code{matrix} when \code{x} is a \code{list} of \code{matrix} objects, and \code{data.frame}s for \code{data.frame} replicates. In case \code{FUN=NULL}: if \code{x} is a list of \code{vectors}, the function will return a \code{matrix}; an \code{array} is returned, if \code{x} is a \code{list} of \code{matrix} class obejcts; if \code{x} is a list of \code{data.frame} objects, the function returns a \code{data.frame}.
}
\description{
This pseudo-generic function iterates a function on the subelements of a list of objects that have the same class and matching dimensions/names and reorganizes the result to match the structure of the replicates or a prototype template.
}
\details{
The function is designed to unify/merge objects that result from the same function applied to different source data (e.g. the results of \code{subsample()}). In its current form, the function supports \code{vectors} (including one-dimensional \code{tables} and \code{arrays}), \code{matrix} and \code{data.frame} objects.
}
\examples{
# basic example
vect <- rnorm(100)
# make 50 replicates
repl <- rep(list(vect), 50)
repmatch(repl, FUN=mean, direct="dim")

# named input
  # two vectors
    # a
    a<- 1:10
    names(a) <- letters[1:length(a)]
    a[c(3,5,8)] <- NA
    a <- a[!is.na(a)]
  
    #b
    b<- 10:1
    names(b) <- letters[length(b):1]
    b[c(1, 3,6, length(b))]<- NA
    b <- b[!is.na(b)]

  # list
  x2 <- rep(c(list(a),list(b)), 3)

# simple match - falling through "dim" to "name" directive
repmatch(x2, FUN=NULL)

# prototyped
prot <- 1:10
names(prot) <-letters[1:10]

repmatch(x2, FUN=mean, proto=prot, na.rm=TRUE)
}
