% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdlePoisson.R
\name{HurdlePoisson}
\alias{HurdlePoisson}
\title{Create a hurdle Poisson distribution}
\usage{
HurdlePoisson(lambda, pi)
}
\arguments{
\item{lambda}{Parameter of the Poisson component of the distribution.
Can be any positive number.}

\item{pi}{Zero-hurdle probability, can be any value in \verb{[0, 1]}.}
}
\value{
A \code{HurdlePoisson} object.
}
\description{
Hurdle Poisson distributions are frequently used to model counts
with many zero observations.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a hurdle Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}:
\deqn{
    \lambda \cdot \frac{\pi}{1 - e^{-\lambda}}
  }{
    \lambda \cdot \pi/(1 - e^{-\lambda})
  }

\strong{Variance}: \eqn{m \cdot (\lambda + 1 - m)}, where \eqn{m} is the mean above.

\strong{Probability mass function (p.m.f.)}: \eqn{P(X = 0) = 1 - \pi} and for \eqn{k > 0}

\deqn{
    P(X = k) = \pi \cdot \frac{f(k; \lambda)}{1 - f(0; \lambda)}
  }{
    P(X = k) = \pi \cdot f(k; \lambda)/(1 - f(0; \lambda))
  }

where \eqn{f(k; \lambda)} is the p.m.f. of the \code{\link{Poisson}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}: \eqn{P(X \le 0) = 1 - \pi} and for \eqn{k > 0}

\deqn{
    P(X = k) = 1 - \pi + \pi \cdot \frac{F(k; \lambda)}{1 - F(0; \lambda)}
  }{
    P(X = k) = 1 - \pi + \pi \cdot F(k; \lambda)/(1 - F(0; \lambda))
  }

where \eqn{F(k; \lambda)} is the c.d.f. of the \code{\link{Poisson}} distribution.

\strong{Moment generating function (m.g.f.)}:

\deqn{
    E(e^{tX}) = \frac{\pi}{1 - e^{-\lambda}} \cdot e^{\lambda (e^t - 1)}
  }{
    E(e^(tX)) = \pi/(1 - e^{-\lambda}) \cdot e^(\lambda (e^t - 1))
  }
}
\examples{
## set up a hurdle Poisson distribution
X <- HurdlePoisson(lambda = 2.5, pi = 0.75)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.75))

## cdf() and quantile() are inverses for each other
cdf(X, quantile(X, 0.3))
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{ZIPoisson}()}
}
\concept{discrete distributions}
