% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{dstr}
\alias{dstr}
\alias{dstrs}
\title{Helper Functionality for Constructing Distributions}
\usage{
dstr(d, ..., pars = NULL)

dstrs(d, pars = NULL, ...)
}
\arguments{
\item{d}{(\code{character(1)}) \cr
Distribution. Can be the \code{ShortName} or \code{ClassName} from \code{\link[=listDistributions]{listDistributions()}}.}

\item{...}{(\code{ANY}) \cr
Passed to the distribution constructor, should be parameters or \code{decorators}.}

\item{pars}{(\code{list()}) \cr
List of parameters of same length as \code{d} corresponding to distribution parameters.}
}
\description{
Helper functions for constructing an \link{SDistribution} (with \code{dstr})
or \link{VectorDistribution} (with \code{dstrs}).
}
\examples{
# Construct standard Normal and  distribution
dstr("Norm") # ShortName
dstr("Normal") # ClassName

# Construct Binomial(5, 0.1)
dstr("Binomial", size = 5, prob = 0.1)

# Construct decorated Gamma(2, 1)
dstr("Gamma", shape = 2, rate = 1,
     decorators = "ExoticStatistics")

# Or with a list
dstr("Gamma", pars = list(shape = 2, rate = 4))

# Construct vector with dstrs

# Binomial and Gamma with default parameters
dstrs(c("Binom", "Gamma"))

# Binomial with set parameters and Gamma with
#  default parameters
dstrs(c("Binom", "Gamma"), list(list(size = 4), NULL))

# Binomial and Gamma with set parameters
dstrs(c("Binom", "Gamma"),
     list(list(size = 4), list(rate = 2, shape = 3)))

# Multiple Binomials
dstrs("Binom", data.frame(size = 1:5, prob = 0.5))

}
