\name{simplifyr-methods}
\docType{methods}
\alias{simplifyr-methods}
\alias{simplifyr}
\alias{simplifyr,UnivariateDistribution-method}
\title{ Methods for Function simplifyr in Package `distr'}
\description{simplifyr-methods}

\section{Methods}{\describe{

\item{simplifyr}{\code{signature(.Object = "UnivariateDistribution")}: After several transformations of a given distribution it may take quite 
a long time  to generate random numbers from the resulting distribution. simplifyr generates a certain number, 
by default \eqn{10^5}, of random numbers once. This pool of random numbers forms the basis for further uses of the 
r-method. That is, random numbers are generated by sampling with replacement out of this pool. }
}}
\note{ If you want to generate many random numbers, you should use simplifyr with a big size to be sure,
that your numbers are really random. } # vielleicht nochmal umschreiben?

\seealso{
\code{\link{Distribution-class}}
}

\examples{
F <- ( Norm() + Binom() + Pois() + Exp() ) * 2 - 10
system.time(r(F)(10^6))
simplifyr(F, size = 10^6)
system.time(r(F)(10^6))}

\keyword{}
