% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{predict_PDP.2D.Plotter}
\alias{predict_PDP.2D.Plotter}
\title{Two Dimensional Prediction Curve for PDP Plots}
\usage{
predict_PDP.2D.Plotter(object, feat.2d, save = TRUE)
}
\arguments{
\item{object}{The Interpreter object to use.}

\item{feat.2d}{A 2-column dataframe or matrix that gives the first variable in
in the first column, and the second variable in the next. The
number of rows is equal to the number of 2-D PDPs one would like.}

\item{save}{A boolean indicator to indicate whether the calculations should be
saved in the interpreter object or not. This can help reduce
computation if the PDP functions are used many times, but requires
additional memory to store the predictions. By default, this is set
to TRUE.}
}
\value{
A list of data frames for each pair of features.2d. Each data frame
        contains columns corresponding to the grid points for the two selected
        features and a column corresponding to the predictions of the model
        at the given combination of grid points.
}
\description{
Gives prediction surface for all specified feature pairs in the
             interpreter object (features.2d)
}
\details{
predict_PDP.2D.Plotter
}
\note{
This method is meant to primarily be used to find the exact values for the 2-D PDP
curves or heatmap plotted. Note that after the PDP curve is plotted, the returned
object of this function will be the saved predictions for plotting the curve, rather
than a recalculation of the values.
}
