% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar.utilities.R
\name{covar.utilities}
\alias{covar.utilities}
\alias{get.covar}
\alias{axis.covar}
\title{Utilities for a dispRity object with covariance matrices}
\usage{
get.covar(data, subsets, sample, n, dimensions)

axis.covar(data, subsets, sample, n, dimensions, level = 0.95, axis = 1)
}
\arguments{
\item{data}{a \code{dispRity} object with a \code{covar} element.}

\item{subsets}{optional, a \code{numeric} or \code{character} for which subsets to get (if missing, the value for all subsets are given).}

\item{sample}{optional, one or more specific posterior sample IDs (is ignored if n is used) or a function to summarise all axes.}

\item{n}{optional, a random number of covariance matrices to sample (if left empty, all are used).}

\item{dimensions}{optional, which dimensions to use. If missing the dimensions from \code{data} are used.}

\item{level}{which confidence interval level to use (default is \code{0.95}).}

\item{axis}{which major axis to calculate (default is \code{1}, the first one).}
}
\description{
Different utility functions to extract aspects of a \code{MCMCglmm} object.
}
\examples{
## Load the Charadriiformes dataset
data(charadriiformes)
## Making a dispRity object with covar data
covar_data <- MCMCglmm.subsets(data       = charadriiformes$data,
                               posteriors = charadriiformes$posteriors)

## Get the two first covar matrices for each level
get.covar(covar_data, sample = c(1,2))
## Get 2 random covar matrices in 2D for each level
get.covar(covar_data, n = 2, dimensions = c(1,2))
## Get mean covar matrix for each level
get.covar(covar_data, sample = mean)

## Get the 0.95 major axis for the 42th covar matrix
axis.covar(covar_data, sample = 42)
## Get the 0.5 major axis for 2 random samples
axis.covar(covar_data, n = 1, level = 0.5)
## Get the median 0.95 minor axis of the 2D ellipse
axis.covar(covar_data, sample = mean, dimensions = c(1,2), axis = 2)

}
\seealso{
\code{\link{MCMCglmm.subsets}}
}
\author{
Thomas Guillerme
}
