% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.metric.R
\name{nodes.coordinates}
\alias{nodes.coordinates}
\title{Nodes coordinates}
\usage{
nodes.coordinates(matrix, tree, full = TRUE)
}
\arguments{
\item{matrix}{The \code{matrix} on which \code{\link{centroids}} will be applied}

\item{tree}{A tree topology of class \code{"phylo"}.}

\item{full}{Whether to get the centroids for all ancestors down to the root (\code{TRUE} - default) or only the direct ancestors (\code{FALSE})}
}
\value{
A \code{matrix} if \code{full = FALSE} or a \code{list} of matrices if \code{full = TRUE}.
}
\description{
Calculates ancestral nodes coordinates in a format that can be passed to \code{\link{ancestral.dist}}
}
\examples{
## A random matrix
matrix <- matrix(rnorm(90), 9, 10)
## A random treee with node labels
tree <- rtree(5) ; tree$node.label <- paste0("n", 1:4)
## Adding the tip and node names to the matris
rownames(matrix) <- c(tree$tip.label, tree$node.label)

## Calculating the direct ancestral nodes
direct_anc_centroids <- nodes.coordinates(matrix, tree, full = FALSE)
## Calculating all the ancestral nodes
all_anc_centroids <- nodes.coordinates(matrix, tree, full = TRUE)

## Calculating the distances from the direct ancestral nodes
ancestral.dist(matrix, nodes.coords = direct_anc_centroids)
## Calculating the distances from all the ancestral nodes
ancestral.dist(matrix, nodes.coords = all_anc_centroids)

}
\seealso{
\code{\link{ancestral.dist}}, \code{\link{dispRity.metric}}, \code{\link{dispRity}}
}
\author{
Thomas Guillerme
}
