% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bloom-filter.r
\name{make_bloomfilter}
\alias{make_bloomfilter}
\alias{bf_likely_in_chunks}
\alias{use_bloom_filter}
\title{Use bloomfilters to make}
\usage{
make_bloomfilter(df, cols, ...)

bf_likely_in_chunks(df, cols, values)

use_bloom_filter(df, cols, values)
}
\arguments{
\item{df}{a disk.frame}

\item{cols}{columns to make bloomfilters with}

\item{...}{not used}

\item{values}{the values to lookup using bloomfilter}
}
\description{
Use bloomfilters to make

Return the chunks that values are in certain chunks

Use bloomfilter
}
\examples{
df = nycflights13::flights \%>\% as.disk.frame(shardby = c("carrier"))
values = "UA"
system.time(make_bloomfilter(df, "carrier"))
bf_likely_in_chunks(df, "carrier", values)
system.time(bf_likely_in_chunks(df, "carrier", "values"))

system.time(d1 <- df \%>\% 
  use_bloom_filter("carrier",  "UA") \%>\% 
  collect)
}
\concept{bloomfilter}
