% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{e_vert}
\alias{e_vert}
\title{Vertical representation for centers of clusters.}
\usage{
e_vert(centros, colores = NULL)
}
\arguments{
\item{centros}{a data.frame object with the centers of the clusters.}

\item{colores}{a vector of color for each cluster.}
}
\value{
echarts4r plot
}
\description{
Vertical representation for centers of clusters.
}
\examples{
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
c <- calc.centros(iris[, -5], clusters)
e_vert(c$real, c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
