% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{hc_horiz}
\alias{hc_horiz}
\title{Horizontal representation for centers of clusters.}
\usage{
hc_horiz(centros, nombre.archivo = NULL, colors = NULL)
}
\arguments{
\item{centros}{a data.frame object with the centers of the clusters.}

\item{nombre.archivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colors}{a vector of color for each cluster.}
}
\value{
Highchart plot
}
\description{
Horizontal representation for centers of clusters.
}
\examples{
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
c <- calc.centros(iris[, -5], clusters)
hc_horiz(c$real, 'horizontal', c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
