% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_month.R, R/get_quarter.R, R/get_year.R
\name{get_month}
\alias{get_month}
\alias{get_quarter}
\alias{get_year}
\title{Get Year, Quarter or Month}
\usage{
get_month(x)

get_quarter(x)

get_year(x)
}
\arguments{
\item{x}{a \link{date_xx} or any \R object that can be coerced to \code{POSIXlt}}
}
\value{
an \code{integer} vector.
}
\description{
Get Year, Quarter or Month
}
\details{
If you use \pkg{lubridate} in addition to dint,
you can also use \code{\link[lubridate:year]{lubridate::year()}}, \code{\link[lubridate:month]{lubridate::month()}} and
\code{\link[lubridate:quarter]{lubridate::quarter()}} with dint objects.
}
\examples{
x <- date_yq(2016, 2)
get_month(x)
\dontrun{
library(lubridate)
month(x)
}
x <- date_yq(2016, 2)
get_quarter(x)
\dontrun{
library(lubridate)
quarter(x)
}

x <- date_yq(2016, 2)
get_year(x)
\dontrun{
library(lubridate)
year(x)
}

}
\seealso{
\code{\link[lubridate:year]{lubridate::year()}},
\code{\link[lubridate:month]{lubridate::month()}},
\code{\link[lubridate:quarter]{lubridate::quarter()}}
}
