% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PCOA-class}
\alias{PCOA-class}
\alias{.PCOA}
\title{PCoA Results}
\description{
An S4 class to store the results of a principal coordinates analysis.
}
\section{Slots}{

\describe{
\item{\code{points}}{A \code{numeric} matrix whose rows give the coordinates of the points
chosen to represent the dissimilarities.}

\item{\code{eigenvalues}}{A \code{\link{numeric}} vector giving the eigenvalues computed during
the scaling process.}

\item{\code{method}}{A \code{\link{character}} string giving the distance that has been used to
create the distance structure.}

\item{\code{GOF}}{A length-two \code{\link{numeric}} vector.}

\item{\code{groups}}{A \code{\link{character}} vector specifying the class for each
observation.}
}}

\examples{
## Load data
data("iris")

## Compute euclidean distances
d <- dist(iris[, 1:4], method = "euclidean")

## Compute principal coordinates analysis
X <- pcoa(d)

## Screeplot
screeplot(X)

## Plot results
plot(X, extra_quali = iris$Species)

## Add convex hulls
plot(
  x = X,
  extra_quali = iris$Species,
  hull = TRUE
)

## Add tolerance ellipses
plot(
  x = X,
  extra_quali = iris$Species,
  ellipse = list(type = "tolerance", level = 0.95)
)
}
\seealso{
Other class: 
\code{\link{BootstrapCA-class}},
\code{\link{BootstrapPCA-class}},
\code{\link{CA-class}},
\code{\link{MCA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}},
\code{\link{PCA-class}}
}
\author{
N. Frerebeau
}
\concept{class}
\keyword{internal}
