% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRedData-class.R
\docType{class}
\name{dimRedData-class}
\alias{dimRedData-class}
\alias{dimRedData}
\alias{as.data.frame,dimRedData-method}
\alias{getData,dimRedData-method}
\alias{getMeta,dimRedData-method}
\alias{nrow,dimRedData-method}
\alias{[,dimRedData,ANY,ANY,ANY-method}
\alias{ndims,dimRedData-method}
\title{Class "dimRedData"}
\usage{
\S4method{as.data.frame}{dimRedData}(x, meta.prefix = "meta.",
  data.prefix = "")

\S4method{getData}{dimRedData}(object)

\S4method{getMeta}{dimRedData}(object)

\S4method{nrow}{dimRedData}(x)

\S4method{[}{dimRedData,ANY,ANY,ANY}(x, i)

\S4method{ndims}{dimRedData}(object)
}
\arguments{
\item{x}{Of class dimRedData}

\item{meta.prefix}{Prefix for the columns of the meta data names.}

\item{data.prefix}{Prefix for the columns of the variable names.}

\item{object}{Of class dimRedData.}

\item{i}{a valid index for subsetting rows.}
}
\description{
A class to hold data for dimensionality reduction and methods.
}
\details{
The class hast two slots, \code{data} and \code{meta}. The
\code{data} slot contains a \code{numeric matrix} with variables in
columns and observations in rows. The \code{meta} slot may contain
a \code{data.frame} with additional information. Both slots need to
have the same number of rows or the \code{meta} slot needs to
contain an empty \code{data.frame}.

See examples for easy conversion from and to \code{data.frame}.

For plotting functions see \code{\link{plot.dimRedData}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.data.frame}: convert to data.frame

\item \code{getData}: Get the data slot.

\item \code{getMeta}: Get the meta slot.

\item \code{nrow}: Get the number of observations.

\item \code{[}: Subset rows.

\item \code{ndims}: Extract the number of Variables from the data.
}}

\section{Slots}{

\describe{
\item{\code{data}}{of class \code{matrix}, holds the data, observations in
rows, variables in columns}

\item{\code{meta}}{of class \code{data.frame}, holds meta data such as
classes, internal manifold coordinates, or simply additional
data of the data set. Must have the same number of rows as the
\code{data} slot or be an empty data frame.}
}}

\examples{
## Load an example data set:
s3d <- loadDataSet("3D S Curve")

## Create using a constructor:

### without meta information:
dimRedData(iris[, 1:4])

### with meta information:
dimRedData(iris[, 1:4], iris[, 5])

### using slot names:
dimRedData(data = iris[, 1:4], meta = iris[, 5])

## Convert to a dimRedData objects:
Iris <- as(iris[, 1:4], "dimRedData")

## Convert to data.frame:
head(as(s3d, "data.frame"))
head(as.data.frame(s3d))
head(as.data.frame(as(iris[, 1:4], "dimRedData")))

## Extract slots:
head(getData(s3d))
head(getMeta(s3d))

## Get the number of observations:
nrow(s3d)

## Subset:
s3d[1:5, ]

## Shuffle data:
s3 <- s3d[nrow(s3d)]

## Get the number of variables:
ndims(s3d)

}
\seealso{
Other dimRedData: \code{\link{as.dimRedData}}

Other dimRedData: \code{\link{as.dimRedData}}
}
\concept{dimRedData}
