% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_matrix.R
\name{get_distance_matrix_from_T}
\alias{get_distance_matrix_from_T}
\alias{get_DDM_from_T}
\alias{get_distance_matrix_from_Pi}
\alias{get_DDM_from_Pi}
\title{Diffusion distance matrix from a custom transition matrix}
\usage{
get_distance_matrix_from_T(Pi, tau, verbose = TRUE)

get_DDM_from_T(Pi, tau, verbose = TRUE)

get_distance_matrix_from_Pi(Pi, tau, verbose = TRUE)

get_DDM_from_Pi(Pi, tau, verbose = TRUE)
}
\arguments{
\item{Pi}{a transition matrix (it should be a stochastic matrix)}

\item{tau}{diffusion time}

\item{verbose}{default TRUE}
}
\value{
The diffusion distance matrix \eqn{D_t}, a square numeric matrix
  of the \eqn{L^2}-norm distances between posterior probability vectors, i.e.
  Euclidean distances between the rows of the stochastic matrix
  \eqn{P(t) = e^{-\tau L}}, where \eqn{-L = -(I - T)} is the generator of the
  continuous-time random walk (Markov chain) corresponding to the
  discrete-time transition matrix \eqn{T=}\code{Pi}.
}
\description{
Returns a matrix where each entry encodes the diffusion distance
between two nodes of a network, given a transition matrix on the network
and a diffusion time.

The diffusion distance at time \eqn{\tau} between nodes \eqn{i, j \in G}
is defined as
\deqn{D_{\tau}(i, j) = \vert \mathbf{p}(t|i) - \mathbf{p}(t|j) \vert_2}
with \eqn{\mathbf{p}(t|i) = (e^{- \tau L})_{i\cdot} = \mathbf{e}_i e^{- \tau L}}
indicating the i-th row of the stochastic matrix \eqn{e^{- \tau L}} and
representing the probability (row) vector of a random walk dynamics
corresponding to the initial condition \eqn{\mathbf{e}_i}, i.e. the random
walker is in node \eqn{i} at time \eqn{\tau = 0} with probability 1.

The Laplacian \eqn{L} is the normalised laplacian corresponding to the
given transition matrix, i.e. \eqn{L = I - Pi}.
}
\examples{
g <- igraph::sample_pa(10, directed = FALSE)
dm <- get_distance_matrix(g, tau = 1)
}
\references{
De Domenico, M. (2017). Diffusion Geometry Unravels the Emergence of
  Functional Clusters in Collective Phenomena. Physical Review Letters.
  \doi{10.1103/PhysRevLett.118.168301}

  Bertagnolli, G., & De Domenico, M. (2021). Diffusion geometry of multiplex and
  interdependent systems. Physical Review E, 103(4), 042301.
  \doi{10.1103/PhysRevE.103.042301}
  \href{https://arxiv.org/abs/2006.13032}{arXiv: 2006.13032}
}
\seealso{
\code{\link{get_distance_matrix} \link{get_diffusion_probability_matrix},
\link{get_diffusion_probability_matrix_from_T}}
}
\keyword{diffusion}
\keyword{distance}
