% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{ddfMLR}
\alias{ddfMLR}
\alias{print.ddfMLR}
\alias{plot.ddfMLR}
\alias{coef.ddfMLR}
\alias{logLik.ddfMLR}
\alias{AIC.ddfMLR}
\alias{BIC.ddfMLR}
\title{DDF detection for nominal data.}
\usage{
ddfMLR(Data, group, focal.name, key, type = "both", match = "zscore", anchor = NULL,
purify = FALSE, nrIter = 10, p.adjust.method = "none", parametrization = "irt",
alpha = 0.05)

\method{print}{ddfMLR}(x, ...)

\method{plot}{ddfMLR}(x, item = "all", title, group.names, ...)

\method{coef}{ddfMLR}(object, SE = FALSE, simplify = FALSE, ...)

\method{logLik}{ddfMLR}(object, item = "all", ...)

\method{AIC}{ddfMLR}(object, item = "all", ...)

\method{BIC}{ddfMLR}(object, item = "all", ...)
}
\arguments{
\item{Data}{character: either the unscored data matrix only, or the unscored data
matrix plus the vector of group. See \strong{Details}.}

\item{group}{numeric or character: either the binary vector of group membership or
the column indicator of group membership. See \strong{Details}.}

\item{focal.name}{numeric or character: indicates the level of \code{group} which corresponds to
focal group}

\item{key}{character: the answer key. See \strong{Details}.}

\item{type}{character: type of DDF to be tested (either \code{"both"} (default), \code{"udif"}, or \code{"nudif"}).
See \strong{Details}.}

\item{match}{specifies matching criterion. Can be either \code{"zscore"} (default, standardized total score),
\code{"score"} (total test score), or vector of the same length as number of observations in \code{Data}. See \strong{Details}.}

\item{anchor}{Either \code{NULL} (default) or a vector of item names or item identifiers specifying which items are
currently considered as anchor (DDF free) items. Argument is ignored if \code{match} is not \code{"zscore"} or \code{"score"}.}

\item{purify}{logical: should the item purification be applied? (default is \code{FALSE}). See \strong{Details}.}

\item{nrIter}{numeric: the maximal number of iterations in the item purification (default is 10).}

\item{p.adjust.method}{character: method for multiple comparison correction.
See \strong{Details}.}

\item{parametrization}{character: parametrization of regression coefficients. Possible options are
\code{"irt"} (default) and \code{"classic"}. See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{x}{an object of 'ddfMLR' class}

\item{...}{other generic parameters for \code{print} or \code{plot} functions.}

\item{item}{numeric or character: either the vector of column indicator (number or column name) or \code{'all'}
(default) for all items. See \strong{Details}.}

\item{title}{string: title of plot.}

\item{group.names}{character: names of reference and focal group.}

\item{object}{an object of 'ddfMLR' class}

\item{SE}{logical: should be standard errors also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the result be simplified to a matrix? (default is \code{FALSE}).}
}
\value{
A list of class 'ddfMLR' with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{mlrPAR}}{the estimates of final model.}
  \item{\code{mlrSE}}{standard errors of the estimates of final model.}
  \item{\code{parM0}}{the estimates of null model.}
  \item{\code{parM1}}{the estimates of alternative model.}
  \item{\code{alpha}}{numeric: significance level.}
  \item{\code{DDFitems}}{either the column indicators of the items which were detected as DDF, or \code{"No DDF item detected"}.}
  \item{\code{type}}{character: type of DDF that was tested.}
  \item{\code{purification}}{\code{purify} value.}
  \item{\code{nrPur}}{number of iterations in item purification process. Returned only if \code{purify}
  is \code{TRUE}.}
  \item{\code{ddfPur}}{a binary matrix with one row per iteration of item purification and one column per item.
  "1" in i-th row and j-th column means that j-th item was identified as DDF in i-1-th iteration. Returned only
  if \code{purify} is \code{TRUE}.}
  \item{\code{conv.puri}}{logical indicating whether item purification process converged before the maximal number
  \code{nrIter} of iterations. Returned only if \code{purify} is \code{TRUE}.}
  \item{\code{p.adjust.method}}{character: method for multiple comparison correction which was applied.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{group}}{the vector of group membership.}
  \item{\code{Data}}{the data matrix.}
  \item{\code{match}}{matching criterion.}
  \item{\code{group.names}}{levels of grouping variable.}
  \item{\code{llM0}}{log-likelihood of null model.}
  \item{\code{llM1}}{log-likelihood of alternative model.}
  \item{\code{AICM0}}{AIC of null model.}
  \item{\code{AICM1}}{AIC of alternative model.}
  \item{\code{BICM0}}{BIC of null model.}
  \item{\code{BICM1}}{BIC of alternative model.}
  }
}
\description{
Performs DDF detection procedure for nominal data based on multinomial
log-linear regression model and likelihood ratio test of submodel.
}
\details{
Performs DDF detection procedure for nominal data based on multinomial
log-linear regression model and likelihood ratio test of submodel.

The \code{Data} is a matrix which rows represents examinee unscored answers and
columns correspond to the items. The \code{group} must be either a vector of the same
length as \code{nrow(Data)} or column indicator of \code{Data}. The \code{key} must be
a vector of correct answers corresponding to columns of \code{Data}.

The \code{type} corresponds to type of DDF to be tested. Possible values are \code{"both"}
to detect any DDF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DDF or
\code{"nudif"} to detect only non-uniform DDF.

Argument \code{match} represents the matching criterion. It can be either the standardized test score (default, \code{"zscore"}),
total test score (\code{"score"}), or any other continuous or discrete variable of the same length as number of observations
in \code{Data}.

A set of anchor items (DDF free) can be specified through the \code{anchor} argument. It need to be a vector of either
item names (as specified in column names of \code{Data}) or item identifiers (integers specifying the column number).
In case anchor items are provided, only these items are used to compute matching criterion \code{match}. If the \code{match}
argument is not either \code{"zscore"} or \code{"score"}, \code{anchor} argument is ignored.  When anchor items are
provided, purification is not applied.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the
\code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.
See also \code{\link[stats]{p.adjust}} for more information.

Argument \code{parametrization} is a character which specifies parametrization of regression parameters. Default option
is \code{"irt"} which returns IRT parametrization (difficulty-discrimination). Option \code{"classic"} returns
intercept-slope parametrization with effect of group membership and interaction with matching criterion.

The output of the \code{ddfMLR} function is displayed by the \code{print.ddfMLR} function.

The characteristic curve for item specified in \code{item} option can be plotted. \code{item} can be
column indicator (numeric or character - column name) or \code{"all"} (default). For option \code{"all"},
characteristic curves of all converged items are plotted. The drawn curves represent best model.

Missing values are allowed but discarded for item estimation. They must be coded as \code{NA}
for both, \code{Data} and \code{group} parameters.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMATtest, GMATkey)

Data  <- GMATtest[, 1:20]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# Testing both DDF effects with Benjamini-Hochberg adjustment method
ddfMLR(Data, group, focal.name = 1, key, p.adjust.method = "BH")

# Testing both DDF effects with item purification
ddfMLR(Data, group, focal.name = 1, key, purify = T)

# Testing uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "udif")
# Testing non-uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "nudif")

# Testing both DDF effects with total score as matching criterion
ddfMLR(Data, group, focal.name = 1, key, match = "score")

# Testing both DDF effects using classic parametrization
ddfMLR(Data, group, focal.name = 1, key, parametrization = "classic")

# Graphical devices
plot(x, item = 1)
plot(x, item = 1, group.names = c("Group 1", "Group 2"))
plot(x, item = x$DDFitems)
plot(x, item = "all")

# AIC, BIC, log-likelihood
AIC(x); BIC(x); logLik(x)
# AIC, BIC, log-likelihood for the first item
AIC(x, item = 1); BIC(x, item = 1); logLik(x, item = 1)

# estimates
coef(x)
coef(x, SE = TRUE)
coef(x, SE = TRUE, simplify = TRUE)
}

}
\seealso{
\code{\link[stats]{p.adjust}} \code{\link[nnet]{multinom}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
hladka@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
}
\keyword{DDF}
