#' DIF and DDF Detection by Non-Linear Regression Models.
#'
#' @description The difNLR package containts method for detection of differential item functioning (DIF)
#' based on non-linear regression. Both uniform and non-uniform DIF effects can be detected when considering
#' one focal group. The method also allows to test the difference in guessing or inattention parameters
#' between reference and focal group. DIF detection method is based either on likelihood-ratio test, or on F-test
#' of submodel. Package also offers method for detection of differential distractor functioning (DDF)
#' based on multinomial log-linear regression model and newly for ordinal data via adjacent and cumulative
#' logistic regression models.
#'
#' @aliases difNLR-package
#'
#' @import ggplot2
#' @importFrom CTT score
#' @importFrom grDevices hcl
#' @importFrom methods is
#' @importFrom nnet multinom
#' @importFrom plyr ldply
#' @importFrom reshape2 melt
#' @importFrom stats AIC as.formula anova BIC coef complete.cases deriv3 deviance fitted logLik na.omit nls p.adjust p.adjust.methods pf pchisq rbinom relevel rnorm setNames symnum qf qchisq quantile vcov
#' @importFrom msm deltamethod
#' @importFrom VGAM acat AICvlm BICvlm cumulative lrtest_vglm
#'
#' @details
#' Package: difNLR\cr
#' Type: Package\cr
#' Version: 1.3.0\cr
#' Date: 2019-08-19\cr
#' Depends: R (>= 3.1)
#' Imports: CTT, ggplot2 (>= 2.2.1), grDevices, methods, msm, nnet, plyr, reshape2, stats, VGAM\cr
#' License: GPL-3\cr
#' BugReports: https://github.com/adelahladka/difNLR/issues
#' Encoding: UTF-8
#'
#' @author
#' Adela Hladka (nee Drabinova) \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' Faculty of Mathematics and Physics, Charles University \cr
#' hladka@cs.cas.cz \cr
#'
#' Patricia Martinkova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' martinkova@cs.cas.cz \cr
#'
#' @references
#' Agresti, A. (2010). Analysis of ordinal categorical data. Second edition. John Wiley & Sons.
#'
#' Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
#' Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517,
#' \url{https://doi.org/10.1111/jedm.12158}.
#'
#' Kingston, N., Leary, L., & Wightman, L. (1985). An Exploratory Study of the Applicability of Item Response Theory
#' Methods to the Graduate Management Admission Test. ETS Research Report Series, 1985(2) : 1-64.
#'
#' Martinkova, P., Drabinova, A., Liaw, Y. L., Sanders, E. A., McFarland, J. L., & Price, R. M. (2017).
#' Checking equity: Why Differential Item Functioning Analysis Should Be a Routine Part of Developing Conceptual
#' Assessments. CBE-Life Sciences Education, 16(2), \url{https://doi.org/10.1187/cbe.16-10-0307}.
#'
#' Swaminathan, H. & Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures.
#' Journal of Educational Measurement, 27, 361-370.
#'
#' Vlckova, K. (2014). Test and Item Fairness (Unpublished master's thesis).
#'
#' @note This package was supported by grant funded by Czech Science foundation under number GJ15-15856Y.
#' @docType package
"_PACKAGE"
#> [1] "_PACKAGE"
