% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPolarized.r
\name{plotPolarized}
\alias{plotPolarized}
\title{Plot Polarized Genotypes}
\usage{
plotPolarized(
  genotypes,
  HI,
  cols = c("#FFFFFF", "#800080", "#FFE500", "#008080"),
  type = "rectangle",
  showProgress = FALSE,
  addMarkerAxis = FALSE,
  ...
)
}
\arguments{
\item{genotypes}{A character matrix with _012 encoding of genotypes. Rows represent
individuals, columns represent markers.}

\item{HI}{A numeric vector of hybrid indices, one per individual (row in
\code{genotypes}).}

\item{cols}{A vector of four colors representing: missing data, homozygotes for 0,
heterozygotes, and homozygotes for 2 (in that order).}

\item{type}{Character string specifying the layout of the plot. Accepted values are
\code{"rectangle"}, \code{"iris"}, or \code{"circular"}. Partial matching is allowed.}

\item{showProgress}{Logical. If \code{TRUE}, prints a percentage indicator as individuals
are plotted (applies only to iris plots).}

\item{addMarkerAxis}{Logical. If \code{TRUE}, a default marker axis is added below the
genotype matrix (in rectangular layout) or as a radial axis (in circular layout).
Requires either \code{includedSites} or \code{axisInfo}. For full customization of the
axis (e.g., styling, label orientation), use \code{plotMarkerAxis} manually.}

\item{...}{Additional arguments passed to internal plotting functions. See Details.}
}
\value{
No return value. Called for its side effects - a visual plot of polarized genotypes.
In the default color scheme:
\itemize{
\item Purple and teal represent homozygotes (\code{0} and \code{2}),
\item Yellow represents heterozygotes (\code{1}),
\item White indicates missing or undetermined genotypes (\verb{_}).
Individuals are ordered by increasing \code{HI} (bottom up in rectangular plots and
inside out in circular plots).
}
}
\description{
Plots genotypes that can be optionally polarized and visualized as either a rectangular
or circular (iris-style) plot.
}
\details{
To import and polarize genotypes, use \link{importPolarized}.

When using \link{diem}, the hybrid indices (\code{HI}) are saved in the file
\code{"HIwithOptimalPolarities.txt"}. Alternatively, you can compute \code{HI} directly
from polarized genotypes (see Examples).

By default, the function plots colored tick marks for individuals, with a color change at
the steepest hybrid index gradient. The second and fourth colors in \code{cols} are used
for these ticks. You can:
\itemize{
\item Disable the ticks using \code{tick = FALSE},
\item Provide a vector of tick colors (must match the number of individuals),
\strong{ordered according to \code{order(HI)}},
\item Provide individual \code{labels} (e.g., accession numbers) in the same order as the
rows in \code{genotypes}.
}

If \code{addMarkerAxis = TRUE}, you must also supply either:
\itemize{
\item \code{includedSites} — a file path containing columns \code{CHROM} and \code{POS}, or
\item \code{axisInfo} — a precomputed axis information list, as described in
\code{\link{plotMarkerAxis}}.
}

Additional graphical parameters are passed to internal calls to \code{image()},
\code{axis()}, and \code{plotMarkerAxis()}. The following arguments are supported:

\strong{Image arguments:} \code{zlim}, \code{xlim}, \code{ylim}, \code{add}, \code{xaxs},
\code{yaxs}, \code{xlab}, \code{ylab}, \code{breaks}, \code{useRaster}, \code{asp},
\code{cex}, \code{cex.lab}, \code{cex.main}, \code{cex.sub}, \code{axes},
\code{col.axis}, \code{cex.axis}, \code{family}, \code{font}, \code{font.axis},
\code{font.lab}, \code{font.main}, \code{font.sub}, \code{lab}, \code{xpd}.

\strong{Axis arguments:} \code{side}, \code{at}, \code{col.ticks}, \code{labels},
\code{las}, \code{tick}, \code{line}, \code{pos}, \code{outer}, \code{font},
\code{lty}, \code{lwd}, \code{lwd.ticks}, \code{hadj}, \code{padj}, \code{gap.axis},
\code{xpd}, \code{cex.axis}.
}
\examples{
gen <- importPolarized(
  file = system.file("extdata", "data7x10.txt", package = "diemr"),
  changePolarity = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE),
  ChosenInds = 1:7
)

h <- apply(gen, 1, FUN = function(x) pHetErrOnStateCount(sStateCount(x)))[1, ]

plotPolarized(genotypes = gen, HI = h)

# Incorrect tick color order
plotPolarized(gen, h, col.ticks = c(rep("purple", 5), "green", "purple"), lwd = 3)

# Correct tick color order
plotPolarized(gen, h, col.ticks = c(rep("purple", 5), "green", "purple")[order(h)], lwd = 3)

# Correct individual label order
plotPolarized(gen, h, labels = c(paste("purple", 1:5), "green 1", "purple 6"))
plotPolarized(gen, h, labels = c(paste("purple", 1:5), "green 1", "purple 6"), type = "iris")
}
\seealso{
\link{plotMarkerAxis} for adding chromosome information as a custom
axis to the rectangle genotype plot.
}
