% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vc_leven}
\alias{vc_leven}
\title{VC-sensitive edit distance for Dialectometry}
\usage{
vc_leven(vec1, vec2, alignment_normalization = FALSE, delim = NULL)
}
\arguments{
\item{vec1}{A vector of words.}

\item{vec2}{A vector of words to be compared against.}

\item{alignment_normalization}{A logical value, indicating whether or not the difference scores are to be normalized by alignment length.}

\item{delim}{An optional delimiter, in situations where multiple responses exist in the data.}
}
\value{
A number indicating the number of operations to transform a string to the other, which optionally may undergo length normalization.
}
\description{
An edit distance that is sensitive to vowel and consonant alignment. If the aligned segments are a vowel-consonant pair, the difference is penalized as a score of 2; if not, 1.  Allows for normalization by dividing alignment length, and for accommodating multiple responses with Bilbao distance, as proposed by Aurrekoetxea et al (2020).
}
\examples{
vc_leven("hit", "hot/hit", alignment_normalization = TRUE, delim = "/")
}
\references{
Aurrekoetxea, G., Nerbonne, J., and Rubio, J. 2020. Unifying Analyses of Multiple Responses. \emph{Dialectologia}, 25:59–86.
}
