% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/minus_rectangle_matrix.R
\name{minus_rectangle_matrix}
\alias{minus_rectangle_matrix}
\title{Minus Rectangle Matrix}
\usage{
minus_rectangle_matrix(x, steps = NULL, size = NULL, replacement = 0)
}
\arguments{
\item{x}{a matrix where the dimensions are both multiples of size}

\item{steps}{the required number of steps (block matrices) across the diagonal}

\item{size}{the largest dimension of the matrix being dropped over the diagonal of matrix x}

\item{replacement}{value to be inserted on the diagonal, by default this is zero (0).}
}
\description{
Minus Rectangle Matrix
}
\examples{
# create a non-square matrix
nsm <- matrix(1:27, nrow=9, ncol=3 )

# check that both dimensions are multiples of steps=3
dim(nsm) \%\% 3 == c(0, 0)

# select the diagonal matrix
minus_rectangle_matrix(nsm, steps=3)
}

