% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-dgirtfit-poststratify.r
\docType{methods}
\name{poststratify}
\alias{poststratify}
\alias{poststratify,dgo_fit-method}
\alias{poststratify,data.frame-method}
\title{\code{poststratify}: reweight and aggregate estimates}
\usage{
poststratify(x, target_data, strata_names, aggregated_names,
  proportion_name = "proportion", ...)

\S4method{poststratify}{dgo_fit}(x, target_data, strata_names, aggregated_names,
  proportion_name = "proportion", pars = "theta_bar")

\S4method{poststratify}{data.frame}(x, target_data, strata_names,
  aggregated_names, proportion_name = "proportion", pars = "theta_bar")
}
\arguments{
\item{x}{A \code{data.frame} or \code{dgo_fit} object.}

\item{target_data}{A table giving the proportions contributed to strata by
the interaction of \code{strata_names} and \code{aggregated_names}.}

\item{strata_names}{Names of variables whose interaction defines
population strata.}

\item{aggregated_names}{Names of variables to be aggregated over in
poststratification.}

\item{proportion_name}{Name of the column in \code{target_data} that gives
strata proportions.}

\item{...}{Additional arguments to methods.}

\item{pars}{Selected parameter names.}
}
\value{
A table of poststratified estimates.
}
\description{
This function reweights and aggregates estimates from \code{dgirt} for strata
defined by modeled variables. The names of each of the model's time,
geographic, and demographic grouping variables can be given in either the
\code{strata_names} or \code{aggregated_names} argument. The result has
estimates for the strata indicated by the \code{strata_names} argument,
aggregated over the variables specified in \code{aggregated_names}.
\code{poststratify} requires a table given as \code{target_data} with
population proportions for the interaction of the variables given in
\code{strata_names} and \code{aggregated_names}.
}
\examples{
\dontrun{
data(toy_dgirtfit)

# the stratifying variables should uniquely identify proportions in the
# target data; to achieve this, sum over the other variables
targets <- aggregate(proportion ~ state + year + race3, targets, sum)

# the dgirtfit method of poststratify takes a dgirtfit object, the target
# data, the names of variables that define population strata, and the  names
# of variables to be aggregated over
post <- poststratify(toy_dgirtfit, targets, c("state", "year"), "race3")
}
}
