% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_item_properties}
\alias{add_item_properties}
\title{Add item properties to a project}
\usage{
add_item_properties(db, item_properties = NULL, default_values = NULL)
}
\arguments{
\item{db}{A handle to the dexter project database, e.g. the output of \code{start_new_project}
or \code{open_project}}

\item{item_properties}{A data frame containing a column item_id (mathcing item_id's already defined in the project)
and 1 or more other columns with item properties (e.g. item_type, subject)}

\item{default_values}{a list where the names are item_properties and the values are defaults.
The defaults will be used wherever the item property is unknown.}
}
\value{
nothing
}
\description{
Add, change or define item properties in a dexter project
}
\details{
When entering response data in the form of a rectangular person x item
table, it is easy to provide person properties but practically impossible
to provide item properties. This function provides a possibility to do so.

Note that is is not possible to add new items with this function, 
use \code{\link{touch_rules}} if you want to add new items to your project.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
head(verbAggrProperties)
add_item_properties(db, verbAggrProperties)
get_items(db) 

close_project(db)
}

}
\seealso{
\code{\link{fit_domains}}, \code{\link{profile_plot}} for
 possible uses of item_properties
}
