\docType{data}

\name{data.auto}

\alias{data.auto}

\title{Prices and Qualitative Characteristics of US-Cars}

\format{
A data frame with 52 observations on the following nine variables:
\tabular{ll}{
\code{make} \tab make and model.\cr
\code{price} \tab price (in dollar).\cr
\code{mpgall} \tab mileage (miles per gallon).\cr
\code{headroom} \tab headroom (in inch).\cr
\code{trunk} \tab trunk Space (in cubic foot).\cr
\code{weight} \tab weight (in pound).\cr
\code{length} \tab length (in inch).\cr
\code{turn} \tab turn circle (in foot).\cr
\code{displacement} \tab displacement (in cubic inch).\cr
}
}

\source{
This data frame was imported from an SAS dataset provided by \href{http://euclid.psych.yorku.ca/ftp/sas/sssg/data/auto.sas}{York University, CA}
}

\usage{
data.auto
}

\description{
This is a data set on the prices and qualitative characteristics of US-cars sold in 1979.
}

\details{
In Auer et al. (2023, Chap. 13) these data are used to illustrate the selection process of exogenous variables.
}

\references{
Originally published in: Chambers, J.M, Cleveland, W.S., Kleiner, B., Tukey, P.A. (1983): Graphical Methods for Data Analysis, Wadsworth International Group, pages 352-355.

Auer, L.v., Hoffmann, S. & Kranz, T. (2023): Ökonometrie - Das R-Arbeitsbuch, 2nd ed., Springer-Gabler (\href{https://www.uni-trier.de/index.php?id=15929}{https://www.oekonometrie-lernen.de}).
}

\keyword{datasets}
