% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greeks.R
\name{greeks}
\alias{bsopt}
\alias{greeks}
\alias{greeks2}
\title{Calculate option Greeks}
\usage{
bsopt(s, k, v, r, tt, d)
greeks(f)
# must used named list entries:
greeks2(fn, ...)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{fn}{Pricing function name, not in quotes}

\item{f}{Fully-specified option pricing function, including inputs
which need not be named. For example, you can enter
\code{greeks(bscall(40, 40, .3, .08, .25, 0))}}

\item{...}{Pricing function inputs, must be named, may either be a
list or not}
}
\value{
A named list of Black-Scholes option prices and Greeks.
}
\description{
The functions \code{greeks} and \code{greeks2} provide
two different calling conventions for computing a full set of
option Greeks. \code{greeks} simply requires entering a pricing function
with parameters. \code{greeks2} requires the use of named parameter
entries. The function \code{bsopt} calls \code{greeks2} to
produce a full set of prices and greeks for calls and puts. These
functions are all vectorized, the only restriction being that the
functions will produce an error if the recycling rule can not be
used safely (that is, if parameter vector lengths are not integer
multiples of one another).
}
\details{
Numerical derivatives are calculated using a simple
difference. This can create numerical problems in edge cases. It
might be good to use the package numDeriv or some other more
sophisticated calculation, but the current approach works well with
vectorization.
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0;
greeks(bscall(s, k, v, r, tt, d))
greeks2(bscall, list(s=s, k=k, v=v, r=r, tt=tt, d=d))
greeks2(bscall, list(s=s, k=k, v=v, r=r, tt=tt, d=d))[c('Delta', 'Gamma'), ]
bsopt(s, k, v, r, tt, d)
bsopt(s, c(35, 40, 45), v, r, tt, d)
bsopt(s, c(35, 40, 45), v, r, tt, d)[['Call']][c('Delta', 'Gamma'), ]

## plot Greeks for calls and puts for 500 different stock prices
## Unfortunately, this plot will most likely not display in RStudio;
## it will generate a "figure margins too large" error
k <- 100; v <- 0.30; r <- 0.08; tt <- 2; d <- 0
S <- seq(.5, 250, by=.5)
x <- bsopt(S, k, v, r, tt, d)
par(mfrow=c(4, 4))  ## create a 4x4 plot
for (i in c('Call', 'Put')) {
    for (j in rownames(x[[i]])) {  ## loop over greeks
        plot(S, x[[i]][j, ], main=paste(i, j), ylab=j, type='l')
    }
}
}

