# Class 'MVNresponse' (multivariate normal response model)
setClass("MVNresponse",
  representation(formula="formula"),
  contains="response"
)

setMethod("fit","MVNresponse",
	function(object,w) {
    if(missing(w)) w <- NULL
		pars <- object@parameters
		if(!is.null(w)) fit <- lm.wfit(x=object@x,y=object@y,w=w) else fit <- lm.fit(x=object@x,y=object@y)
		object@parameters$coefficients <- fit$coefficients
		if(!is.null(w)) object@parameters$Sigma <- cov.wt(x=fit$residuals,wt=w)["cov"] else object@parameters$Sigma <- cov(fit$residuals)
		#object <- setpars(object,unlist(pars))
		object
	}
)

dm_dmvnorm <- function(y,mean,sigma,log=FALSE,logdet,invSigma) {
  # taken from mvtnorm package
  # allows passing of logdet (sigma) and invsigma to save 
  # computation when called repeated times with same sigma 
    if (is.vector(x)) {
        x <- matrix(x, ncol = length(x))
    }
    if (missing(mean)) {
        mean <- rep(0, length = ncol(x))
    }
    if (missing(sigma)) {
        sigma <- diag(ncol(x))
    }
    if (NCOL(x) != NCOL(sigma)) {
        stop("x and sigma have non-conforming size")
    }
    if (NROW(sigma) != NCOL(sigma)) {
        stop("sigma must be a square matrix")
    }
    if (length(mean) != NROW(sigma)) {
        stop("mean and sigma have non-conforming size")
    }
    if(missing(invSigma)) {
      distval <- mahalanobis(x, center = mean, cov = sigma) 
    } else {
      if (NCOL(x) != NCOL(invSigma)) {
        stop("x and invSigma have non-conforming size")
      }
      if (NROW(invSigma) != NCOL(invSigma)) {
          stop("invSigma must be a square matrix")
      }
      if (length(mean) != NROW(invSigma)) {
          stop("mean and invSigma have non-conforming size")
      }
      distval <- mahalanobis(x, center = mean, cov = invSigma, inverted=TRUE)
    } 
    if(missing(logdet)) logdet <- sum(log(eigen(sigma, symmetric = TRUE, only.values = TRUE)$values))
    logretval <- -(ncol(x) * log(2 * pi) + logdet + distval)/2
    if (log) {
        return(logretval)
    } else {
      return(exp(logretval))
    }
}


setMethod("logDens","MVNresponse",
	function(object,...) {
		dm_dmvnorm(x=object@y,mean=predict(object),sigma=object@parameters$Sigma,log=TRUE,...)
	}
)

setMethod("dens","MVNresponse",
	function(object,log=FALSE,...) {
		dm_dmvnorm(x=object@y,mean=predict(object),sigma=object@parameters$Sigma,log=log,...)
	}
)

setMethod("simulate",signature(object="MVNresponse"),
  function(object,nsim=1,seed=NULL,times) {
    if(!is.null(seed)) set.seed(seed)
    if(missing(times)) {
      # draw in one go
      mu <- predict(object)
    } else {
      mu <- predict(object)[times,]
    }
    nt <- nrow(mu)
    response <- mvrnorm(nt*nsim,mu=mu,Sigma=object@parameters$Sigma)
    #if(nsim > 1) response <- array(response,dim=c(nt,ncol(response),nsim))
    return(response)
  }
)

MVNresponse <- function(formula,data,pstart=NULL,fixed=NULL,...) {
	call <- match.call()
	mf <- match.call(expand.dots = FALSE)
	m <- match(c("formula", "data"), names(mf), 0)
	mf <- mf[c(1, m)]
	mf$drop.unused.levels <- TRUE
	mf[[1]] <- as.name("model.frame")
	mf <- eval(mf, parent.frame())
	x <- model.matrix(attr(mf, "terms"),mf)
	y <- model.response(mf)
	if(!is.matrix(y)) y <- matrix(y,ncol=1)
	parameters <- list()
	parameters$coefficients <- matrix(0.0,ncol=ncol(y),nrow=ncol(x))
	parameters$Sigma <- diag(ncol(y))
	
	npar <- length(unlist(parameters))
	if(is.null(fixed)) fixed <- as.logical(rep(0,npar))
	if(!is.null(pstart)) {
		if(length(pstart)!=npar) stop("length of 'pstart' must be",npar)
		parameters$coefficients[1,] <- pstart[1:ncol(parameters$coefficients)]
		pstart <- matrix(pstart,ncol(x),byrow=TRUE)
		if(ncol(x)>1) parameters$coefficients[2:ncol(x),] <- pstart[2:ncol(x),]
	   if(length(unlist(parameters))>length(parameters$coefficients)) {
        tmp <- as.numeric(pstart[(length(parameters$coefficients)+1):length(pstart)])
        if(length(tmp) == ncol(parameters$Sigma)) parameters$Sigma <- diag(tmp) else parameters$Sigma <- matrix(tmp,ncol=ncol(y),nrow=ncol(y))
	   }
  }
	mod <- new("MVNresponse",formula=formula,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar)
	mod
}

setMethod("show","MVNresponse",
	function(object) {
		cat("Multivariate Normal Model, formula: ",sep="")
		print(object@formula)
		cat("Coefficients: \n")
		print(object@parameters$coefficients)
		cat("Sigma: \n")
    print(object@parameters$Sigma)
	}
)

setMethod("setpars","MVNresponse",
	function(object, values, which="pars", prob=FALSE, ...) {
		npar <- npar(object)
		if(length(values)!=npar) stop("length of 'values' must be",npar)
		# determine whether parameters or fixed constraints are being set
		nms <- names(object@parameters$coefficients)
		switch(which,
			"pars" = {
				object@parameters$coefficients <- matrix(values[1:length(object@parameters$coefficients)],ncol(object@x))
			  if(length(unlist(object@parameters))>length(object@parameters$coefficients)) {
          st <- length(object@parameters$coefficients)+1
          object@parameters$Sigma <- matrix(as.numeric(values[st:(st+length(object@parameters$Sigma))]),ncol=ncol(object@parameters$Sigma),nrow=nrow(object@parameters$Sigma))
			  }
			},
			"fixed" = {
				object@fixed <- as.logical(values)
			}
		)
		names(object@parameters$coefficients) <- nms
		return(object)
	}
)
setMethod("getpars","MVNresponse",
	function(object,which="pars",...) {
		switch(which,
			"pars" = {
				parameters <- numeric()
				parameters <- unlist(object@parameters)
				pars <- parameters
			},
			"fixed" = {
				pars <- object@fixed
			}
		)
		return(pars)
	}
)
