% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{G.spline}
\alias{G.spline}
\title{Family of spline instrumental functions}
\usage{
G.spline(
  x,
  g.idx,
  data,
  n.if.per.cov,
  norm.func,
  cov.ranges = NULL,
  norm.cov.out = NULL,
  degree = 3
)
}
\arguments{
\item{x}{The vector of covariates at which to evaluate the B-splines}

\item{g.idx}{The index of the instrumental function. Note that g.idx ranges
between 1 and n.if.per.cov^n.cov, as an instrumental function is the product
of the appropriate B-spline evaluation for each element in the covariate
vector.}

\item{data}{Data frame containing the data.}

\item{n.if.per.cov}{Number of instrumental variables to be used per covariate.}

\item{norm.func}{Function to be used to normalize the covariates.}

\item{cov.ranges}{Matrix of ranges of the covariates. Used for normalizing
the covariates. If \code{cov.ranges = NULL}, the data will be normalized in a
data-dependent way. Default is \code{cov.ranges = NULL}.}

\item{norm.cov.out}{Output of a preliminary call to the given covariate
normalization function. Default is \code{norm.cov.out = NULL}.}

\item{degree}{Degree of B-splines to use. Default value is \code{degree = 3}.}
}
\description{
This function normalizes the covariates to lie in the unit
interval and then evaluates each B-spline at each observation, multiplying
together the results per observation.
}
