% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rw.R
\name{dprings}
\alias{dprings}
\title{Automatically identify tree rings in a density profile}
\usage{
dprings(
  dp,
  pps = 200,
  threshold.sd = 0,
  return.plot = FALSE,
  smooth = FALSE,
  span = 0.01
)
}
\arguments{
\item{dp}{An dp object, see \code{dpload}}

\item{pps}{Points per peak, the minimum width of a peak, half on
each side. A local peak is identified when half of those points
are lower on each side of the potential peak. The inverse is true
in valleys.}

\item{threshold.sd}{Minimum peak value in standard deviations away
from the overall mean of the signal. By default no peaks are
allowed to be beneath the overall mean, can be adjusted to
negative to lower the minimum peak allowed.}

\item{return.plot}{If TRUE, the function will return a diagnostic
plot. Green points are valleys, blue points are peaks and red
points were automatically excluded.}

\item{smooth}{Set to TRUE, the profile will be denoised using a
LOESS regression.}

\item{span}{Span of the LOESS regression.}
}
\value{
A data frame including the values and positions for all
  peaks and values. Usually piped into \code{get_RW} to get ring
  widths.
}
\description{
Called on a density profile it will return tree rings, which were
automatically detected in the density profile. For best results,
run on a trimmed and detrended density profile (use GAM for best
results, see \code{dpdetrend}). The function will then search for
local peaks and valleys within the profile. Normally works well in
softwood species, where density increases in late wood and
decreases in nearly wood. It will return a data frame containing
peaks and valleys, along with their horizontal position. A
diagnostic plot will be returned instead when return.plot = TRUE.
Green points are valleys, blue points are peaks and red points were
automatically excluded. The algorithm will search for peaks and
valleys, after which it will automatically exclude all repeated
points. Each peak should be followed by a valley and vice versa,
when peak-peak situation is found, it will always take the higher
peak and the opposite in valleys (keeps the lowest values). Adjust
sensitivity by either adjusting \code{pps}, which dictates how many
points on each side of the identified peak are the minimum.
Essentially this dictates the minimum width of detected rings, try
adjusting it and display the plot. Minimum peak value can also be
adjusted with the parameter threshold, which dictates how many
stand deviations from the mean amplitude of the profile is the
lowest minimum peak value. Before ring detection the profile can
also be denoised by setting \code{smooth = TRUE}, which applies a
loess regression to smooth the data using the span parameter.
}
\examples{
\donttest{
## load a single file
dp  <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## trim and detrend the measurement
dp.trimmed <- dptrim(dp)
dp.detrended <- dpdetrend(dp.trimmed, type = "gam")
## identify rings
rings <- dprings(dp.detrended)
## plot a diagnostic
dprings(dp.detrended, return.plot = TRUE)
## get tree ring widths:
get_RW(rings)
}
}
\seealso{
get_RW
}
