% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_denoiSeq.R
\docType{class}
\name{readsData}
\alias{readsData}
\title{An S4 class to represent summarised counts and the output of Bayesian inference.}
\description{
An S4 class to represent summarised counts and the output of Bayesian inference.
}
\section{Slots}{

\describe{
\item{\code{counts}}{A positive integer matrix containing summarised counts for each
genomic event (genes, exons, transcripts, etc)  in the two conditions, A and B.}

\item{\code{replicates}}{A list containing the indices of the columns that belong to each  of the two
experimental conditions, A and B. It is defaulted to A = 1:n/2, B = n/2+1:n for an m by n matrix.}

\item{\code{geneNames}}{A character vector containing the names of the genomic event. It is
appropriately defaulted to names of  the matrix.}

\item{\code{initValues}}{A list containing initial values for each parameter. Defaulted to \emph{N_A} = rep(1, nrow(counts)),\emph{N_B} = rep(1, nrow(counts)),\emph{p}= 0.0001, \emph{f} = 0.01}

\item{\code{stepSizes}}{A list containing step sizes for sampling each parameter. Defaulted to stepsizeN_A = rep(1, nrow(counts)),stepsizeN_B = rep(1, nrow(counts)),stepsize_p= 1e3, stepsizeN_A = 5e7}

\item{\code{output}}{A list containing the parameter samples generated by Bayesian inference. It can only be  filled
inside the results function.}
}}

