% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{read_data}
\alias{read_data}
\alias{read_data_matrix}
\alias{read_data_raster}
\title{Import a jpeg image}
\usage{
read_data(filename, dir)

read_data_matrix(filename, dir)

read_data_raster(filename, dir)
}
\arguments{
\item{filename}{name of the jpeg file to import}

\item{dir}{the directory where the image is located}
}
\value{
read_data returns a 3-column data.frame with pixels in rows and
red, green, blue intensities in columns. read_data_matrix reads jpeg images and returns 3 matrices for
each of red, green and blue colors. read_data_raster imports jpeg as a raster object
\code{\link[terra]{rast}}.
}
\description{
All these functions are made to read jpeg images, the difference is in the objects they return
}
\section{Functions}{
\itemize{
\item \code{read_data_matrix}: returns three matrices

\item \code{read_data_raster}: returns a SpatRaster object
}}

\examples{

dir <- system.file('extdata/Forest/', package = "deforestable")

dd <- read_data(filename='_6_33_.jpeg', dir=dir)
hist(dd[,1])


dir <- system.file('extdata/Forest/', package = "deforestable")

dd <- read_data_matrix(filename='_6_33_.jpeg', dir=dir)


dir <- system.file('extdata/Forest/', package = "deforestable")

dd<-read_data_raster(filename='_8_46_.jpeg', dir=dir)

}
