% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/decomp.R
\name{decomp}
\alias{decomp}
\title{Interface function for decompositions}
\usage{
decomp(x, y, k, i, o, method = c("leontief", "wwz"), ...)
}
\arguments{
\item{x}{the intermediate demand table, it has dimensions GN x GN (G = no. of country, N = no. of industries),
excluding the first row and the first column which contains the country names,
and the second row and second column which contain the industry names for each country.
In addition, an extra row at the end should contain final demand.}

\item{y}{the final demand table it has dimensions GN x MN,
excluding the first row and the first column which contains the country names,
the second column which contains the industry names for each country,
and second row which contains the five decomposed final demands (M).
#'}

\item{k}{is a vector of country of region names}

\item{i}{is a vector of sector or industry names}

\item{o}{is a vecotr of final outputs}

\item{method}{user specified the decomposition method}

\item{...}{arguments to pass on the respective decomposition method}
}
\value{
The output when using the WWZ algorithm is a matrix with dimensions GNG*19.
 Whereby 19 is the 16 objects the WWZ algorithm decomposes exports into, plus three checksums.
 GNG represents source country, using industry and using country.
}
\description{
This function runs the decomposition.
NOTE: the default method is now "leontief", please specify method="wwz" explicitly for Wang-Wei-Zhu.
See http://qua.st/decompr/decompr-v2/ for more information.
}
\details{
Version 2 introduces several important changes, the default method is now leontief, which means that wwz has to be specified explicitly.
Furthermore, the input object have a different structure, see the information below for details.
}
\examples{
# load leather example data
data(leather)

# explore the data set
ls()

# explore each of the objects
inter
final
countries
industries
out

# use the direct approach

# run the Leontief decomposition
decomp(inter,
       final,
       countries,
       industries,
       out,
       method = "leontief")

# run the WWZ decomposition
decomp(inter,
       final,
       countries,
       industries,
       out,
       method = "wwz")
}
\author{
Bastiaan Quast
}
\references{
{Timmer, Marcel P. (ed) (2012), "The World Input-Output Database (WIOD): Contents Sources and Methods", WIOD Working Paper Number 10, downloadable at http://www.wiod.org/publications/papers/wiod10.pdf }

{Wang, Zhi, Shang-Jin Wei, and Kunfu Zhu. Quantifying international production sharing at the bilateral and sector levels. No. w19677. National Bureau of Economic Research, 2013.}
}

