% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-schema-df.R
\name{check_schema_df}
\alias{check_schema_df}
\title{Check a data frame of data against a JSON Schema}
\usage{
check_schema_df(
  df,
  schema,
  success_msg = "Data is valid against the schema",
  fail_msg = "Data is invalid against the schema"
)
}
\arguments{
\item{df}{A data frame whose rows will be converted into JSON and validated}

\item{schema}{Contents of the json schema, or a filename
containing a schema.}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}
}
\value{
A condition object indicating whether the data is valid against the
schema.
}
\description{
Each row of the data frame will be converted to JSON and validated against
the given schema.
}
\examples{
dat <- data.frame(
  x = c(NA, 1, NA),
  y = c(NA, NA, "foo")
)
schema <- '{
  "$schema": "http://json-schema.org/draft-04/schema#",
  "properties": {
    "x": {
      "type": "integer"
    },
    "y": {
      "type": "integer"
    }
  },
  "required": ["x", "y"]
}
'
check_schema_df(dat, schema)
}
