library("dbscan")
library("testthat")


context("LOF")

set.seed(665544)
n <- 600
x <- cbind(
  x=runif(10, 0, 5) + rnorm(n, sd=0.4),
  y=runif(10, 0, 5) + rnorm(n, sd=0.4)
)

### calculate LOF score
system.time(lof <- lof(x, minPts = 5))
expect_identical(length(lof), nrow(x))

system.time(lof_d <- lof(dist(x), minPts = 5))
expect_equal(lof, lof_d)

## compare with lofactor from DMwR (k = minPts - 1)
# DMwR is now retired
#if(requireNamespace("DMwR", quietly = TRUE)) {
#  system.time(lof_DMwr <- DMwR::lofactor(x, k = 4))

lof_DMwr <- c(1.03868172280598, 1.07254748249831, 1.14408220715312, 0.944879389452361,
  1.13879178945643, 2.28520199502654, 1.09768616672725, 1.07132503187331,
  0.975921966010123, 0.954939928605744, 1.09182474175867, 0.986873594934701,
  1.12361795077321, 2.28021294574832, 0.99201895114409, 1.04649197013332,
  1.07299663546242, 1.6925296643967, 1.00321565608729, 0.969132288476756,
  1.05610820642351, 0.949305159640817, 1.02091161083026, 0.889727683261715,
  1.0086810363343, 1.07112023488857, 1.05384499534718, 0.973424100193138,
  1.11472889435562, 0.935191253023388, 1.86744007392936, 1.09798200724323,
  0.978269520214317, 1.06134723198216, 0.99883668492889, 1.45710621078376,
  0.992783670585094, 0.944371592613479, 1.00148037202698, 1.0322887730105,
  0.926479498367154, 0.950972932117325, 0.975730505292376, 1.06479564090221,
  1.01846344955183, 1.4289109933519, 1.01667118667763, 0.969219574048815,
  1.08212848653938, 1.12829360531622, 0.987469425989598, 1.10793473557835,
  0.990648703630224, 0.997296192907203, 1.05943637420434, 0.916097780151814,
  1.23938615120607, 1.35785046639085, 0.930095038905002, 1.04899623840037,
  1.14012822308025, 1.18085657443239, 1.03807956334048, 2.06571571812239,
  0.983739191768716, 0.971228687919634, 1.47544466007921, 1.31542909344677,
  1.0589814263668, 1.04866075756247, 1.09861775501196, 1.13757051405833,
  1.01474725626668, 1.76159736020208, 0.972480464117759, 0.971985142159434,
  0.982246973962134, 1.05915605865109, 1.08624364468973, 1.07108441176589,
  1.11300998014878, 0.971912624754668, 1.04556505955201, 0.942622462392568,
  1.09347848051784, 1.12237485528934, 1.17347738796484, 1.00372369546193,
  0.884416185065644, 0.913170514627024, 1.07286873077845, 1.04467554201438,
  1.10835299295398, 0.949250081601518, 1.17047268037031, 1.19141059858204,
  0.945322213261031, 1.1724001054341, 1.18275757580287, 0.961744533314753,
  1.15193980829497, 1.14805323586529, 1.02686916761012, 1.05800883996852,
  1.39255102654674, 1.25713542495119, 0.97033850359919, 1.50308446806373,
  1.02018812660615, 1.00618422279075, 0.991924519599637, 1.27710777666163,
  1.04734074543444, 1.26314895105432, 0.95871463079452, 1.02351936627788,
  0.988292031162705, 0.930228735708188, 1.05931812800875, 0.978051994471004,
  1.10264268785208, 1.06156215489143, 1.02994660206245, 1.22003940945014,
  1.07202289561456, 1.13434990146947, 1.01802890965881, 1.45002578198465,
  0.988639050853758, 0.969400990154326, 1.48811911151213, 1.07752786625793,
  1.03807956334048, 1.23153274659299, 1.03074324567806, 0.961507819773493,
  1.23798280041589, 1.11812015194465, 1.10495407365317, 1.07865242784263,
  0.919758689372277, 1.06422226147049, 0.807398062295378, 0.925150545182537,
  0.99713808643011, 1.51887709240169, 1.06798181940007, 0.994341836541894,
  3.5343815028316, 0.955952564116731, 1.21298185673556, 1.00676721730329,
  1.0175441582464, 1.08752215769321, 1.04037658206407, 2.09986783121188,
  0.987007655088805, 1.3275419750165, 1.00810140059745, 0.960899684409518,
  0.914431142693323, 1.00167771190586, 1.04654688331514, 1.51405618651082,
  1.55602527414607, 1.11251336509933, 1.03105939909642, 1.02455210997756,
  1.72477977752072, 1.05865807138866, 1.07202322584577, 1.05947469225063,
  0.956173981377238, 1.05409517407828, 1.08897920363202, 1.05001398008283,
  1.0216424565457, 0.950972932117325, 0.974081216408259, 1.3065791289215,
  1.00042113852636, 1.01279324752491, 0.979637386225132, 1.05524261668716,
  1.03026127833828, 0.952401712980556, 0.955434071918861, 0.987097050496309,
  0.985722493635314, 0.969904618764268, 1.11224611005095, 1.03198495612326,
  1.08524271516144, 1.05850172603723, 0.97333416939893, 0.961056072030616,
  0.908621935227113, 1.15707469572726, 1.0692320362219, 0.974753825423019,
  1.00843921272482, 1.10630769561269, 0.957378904261285, 1.36727635344809,
  1.36311435759695, 0.966933965020808, 1.09924009030684, 0.994335110205471,
  0.985042385648062, 1.00196233802878, 1.53446976334674, 0.959296603632418,
  0.964566065257235, 1.00761887805913, 1.00561019042615, 1.00660280689484,
  1.01484531029933, 1.00961778056144, 1.09636820922611, 1.03456233281255,
  1.01211580481854, 1.08165822706129, 1.00683264662254, 0.969761143899007,
  0.932288687913464, 1.1414811025744, 1.0266256187261, 0.914326324722949,
  0.960232759570162, 1.1100271829486, 1.08852162532279, 1.07959659800082,
  1.11652651627858, 1.17128662809923, 1.14789808794533, 0.965376933499966,
  1.04199962108483, 1.02450883873424, 1.06192635157104, 1.17291434161797,
  0.975644678124741, 0.993549789778018, 2.85542418410452, 1.00678062327846,
  1.13112487988189, 1.36881000674623, 1.87594457367641, 1.21362680037244,
  1.21120352741194, 0.989143560299435, 1.108982491908, 0.993797283226817,
  0.973092637221254, 1.02875884654416, 1.12754063986521, 1.51355986847978,
  1.0322887730105, 1.07466970806667, 1.01813871608312, 1.2715467003365,
  0.919602152524896, 1.10630769561269, 1.06662012948008, 1.12132297409928,
  1.0850661848376, 0.915099742086528, 1.42866703013906, 0.948895223019406,
  1.10075323793014, 1.22465625967616, 0.9933741914999, 1.12638880645573,
  0.985569041284466, 1.02751252579412, 1.01963999789095, 1.04499891666169,
  0.976729672133105, 0.970436176086775, 0.989783385658022, 1.02460618343222,
  1.09476936212795, 1.21701692832474, 1.13236448825945, 1.23666885707487,
  0.951631583975736, 1.27271075539068, 1.04804587667731, 1.03388217883399,
  1.14188842424683, 1.07336657622837, 1.02309342316775, 0.914986390646287,
  0.948038126532524, 1.03883330172321, 1.12661611917393, 0.961507819773493,
  1.12219682431226, 0.975083566532054, 0.978132025999902, 1.14126976273754,
  0.971695653105757, 1.06756087173881, 1.25945028647061, 1.06332890278609,
  1.14275862451787, 1.07094021483251, 1.03931540654333, 1.32849152431177,
  0.959869814983984, 1.17552239226963, 1.23922791557927, 1.0625964663398,
  1.13385102957048, 1.16311792846184, 1.44994443718783, 1.20366004899713,
  0.960610418432191, 0.992134321102274, 0.893843744261939, 1.17386237110925,
  1.01310616810802, 1.00271742264069, 0.946106941647884, 0.971768544652382,
  1.06454257361741, 1.04649197013332, 1.15026283714279, 0.999056981321562,
  0.97586413923659, 1.16548439536557, 0.996419273078129, 1.10669665394755,
  1.19002408346302, 1.07276251634159, 1.13049088417827, 1.08920652079395,
  0.963784974257182, 1.29422278944583, 1.06192635157104, 1.2733898460815,
  0.984045806499587, 1.10900502527402, 1.04378841817691, 1.02983979869522,
  0.951322144062953, 1.08237913293587, 1.00561019042615, 0.887596723825125,
  1.13858438440359, 0.89471594037654, 1.22902499643975, 2.05632625602702,
  0.938775442464075, 0.96838862031119, 1.20595690734939, 0.992311147792381,
  1.4218394144541, 1.04366597691525, 0.996363895937958, 1.06101074316669,
  1.00494245236634, 0.984497774149002, 1.0292947092455, 0.976832474800795,
  1.05280935271152, 1.01556640409668, 1.15863805224087, 1.04328749888496,
  1.03827432469759, 0.979355737977048, 1.12064713178092, 0.985182007054745,
  1.11380515332537, 1.33978723751844, 1.00627818516985, 0.94749219790245,
  1.20338024154829, 1.08895651803606, 0.917279307174939, 0.974979100624491,
  0.991276534975673, 1.26177407645138, 0.987528918038965, 0.92319729251322,
  1.15434155772645, 1.08455396661788, 0.980577508447126, 0.997699098123072,
  1.00768045219834, 1.02674879418648, 0.991924519599637, 1.06271793086671,
  0.976052783374895, 1.14713995116224, 0.947822989794161, 1.05749660716117,
  1.05605805653911, 0.993903821741236, 1.1754719116391, 0.980444768022468,
  1.18926156717366, 1.29269216128312, 1.0381062261066, 0.999145897276093,
  1.01101919320269, 1.79826370714011, 0.993257484383218, 1.03650716720371,
  1.04763819724135, 0.957214663279126, 1.03629178397033, 0.929586985216379,
  1.1575934188054, 1.09424863481739, 1.13863531161808, 1.04841031600695,
  1.08462614222163, 0.96271052295686, 1.0514676088699, 1.01489711789401,
  0.946856620382385, 1.11037242266678, 1.06379481097341, 1.93438918076037,
  1.052074341916, 1.05269340918463, 1.06798181940007, 1.00453733679384,
  1.34003281000181, 0.959880628862394, 1.0309374339749, 0.955697885296843,
  1.35868684420511, 0.980683234606302, 1.0108764844197, 0.965275118711508,
  1.91717279732129, 1.1786558870462, 1.0223136385601, 0.94911733537556,
  1.00209937781155, 0.977786997605465, 1.06597393904368, 1.43749436891955,
  1.03115526070714, 1.01091935249456, 1.43107093733037, 0.993797283226817,
  1.1235441951347, 1.04752792049789, 1.02210148329631, 1.08104643131331,
  1.69779763700134, 1.09446149945498, 1.05116452864142, 1.09579407662427,
  1.44434574477213, 1.03756368035815, 1.10455427269173, 1.02644140601955,
  1.02058762541389, 1.37539654295047, 1.09761751134433, 1.05392545616365,
  1.03773095989227, 1.05927931105686, 1.01099243211, 1.0427939448524,
  1.11114549796658, 1.04521004957718, 0.974598584078864, 1.37161863191014,
  1.00899313929733, 1.06035585159337, 1.54941468546426, 0.985436636814796,
  1.26625233475015, 0.962383624304064, 1.39298994828844, 0.999678991896731,
  1.00112676054501, 1.01794266025446, 1.04161339831322, 1.7609113569674,
  1.0697789914498, 1.03662405603934, 1.12450677142142, 0.979231092689228,
  0.967654977343203, 0.954257527635656, 1.16843038357801, 1.24829927874691,
  1.26403311737112, 1.02985848209058, 0.911122316357203, 1.06729406239514,
  0.98556314879179, 0.920636580508236, 1.10589314774794, 1.07404255276331,
  0.964961173290562, 1.34608754031566, 0.949305159640817, 1.07633815355142,
  1.07504453641786, 1.10036318447407, 1.06395908792282, 1.09308970955412,
  0.936636747225157, 1.48254777041008, 0.98720732637145, 1.05950172243287,
  0.90985080275372, 0.913252239442344, 0.971502857181872, 1.34455989759247,
  0.944242870890367, 0.99470349817458, 1.57356284286699, 1.01798480471452,
  1.12071575315952, 1.45138453089261, 0.997134924984839, 1.05496977737492,
  1.08291844633695, 0.957091831352896, 1.10633254845018, 1.04983198159987,
  1.69411192510521, 0.976464018284015, 1.05481078557978, 1.04291536166457,
  1.13870775738791, 1.25238595130142, 1.44972946202524, 1.29528885913097,
  1.03455984619014, 1.31887438459667, 1.05932699134397, 0.967147794403,
  0.962865714199544, 0.993535436136372, 1.20206149923855, 0.977945986051667,
  1.02860281569485, 0.936081672509136, 0.95077019789898, 1.0119649036795,
  1.49293997214923, 0.992963575537075, 1.05003738478322, 1.38578735927246,
  1.27113703892726, 1.21834310015872, 1.02842453314088, 1.23719453469118,
  1.13088613635577, 1.38650197285677, 1.0364896445617, 1.22219404896245,
  1.08937579982396, 1.36875064190892, 0.988972770568762, 0.971768544652382,
  0.980444768022468, 1.0066674359898, 0.97033850359919, 1.5495994305199,
  1.07799845873396, 0.923349252815504, 1.10495078966596, 1.07703036015827,
  0.920651912928266, 1.6455570327961, 1.04949588514457, 1.19849228775529,
  1.49672440345181, 0.997699098123072, 1.04762847322216, 0.961264302194931,
  0.9270878113483, 0.96836369246104, 1.15858805197271, 1.03761682577732,
  0.981650892503592, 0.959889619317542, 1.03571295221678, 1.01708775593866,
  0.957852114987982, 0.984983913819399, 0.936395157987655, 0.985620068922779,
  1.02404008318834, 1.17396872232346, 1.12571741965701, 0.977249802972541,
  0.953938913377962, 0.9537187234807, 1.34528717522996, 0.988814620049561
)
  expect_equal(lof, lof_DMwr)
#}

## missing values, but distances are fine
x_na <- x
x_na[c(1,3,5), 1] <- NA
expect_error(lof(x_na), regexp = "NA")
res_d1 <- lof(x_na, search = "dist")
res_d2 <- lof(dist(x_na))
expect_equal(res_d1, res_d2)

x_na[c(1,3,5), 2] <- NA
expect_error(lof(x_na), regexp = "NA")
expect_error(lof(x_na, search = "dist"),
  regexp = "NA")
expect_error(lof(dist(x_na)), regexp = "NA")

## test with tied distances
x <- rbind(1,2,3,4,5,6,7)
expect_equal(round(lof(x, minPts = 4), 7),
  c(1.0679012, 1.0679012, 1.0133929, 0.8730159, 1.0133929, 1.0679012, 1.0679012))

expect_equal(round(lof(dist(x), minPts = 4),7),
  c(1.0679012, 1.0679012, 1.0133929, 0.8730159, 1.0133929, 1.0679012, 1.0679012))

